"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAssetsNavigationTree = void 0;
var _constants = require("../constants");
var _link_groups = require("../link_groups");
var _links = require("../links");
var _i18n_strings = require("../i18n_strings");
var _integrations_link_callout = require("./integrations_link_callout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createAssetsNavigationTree = core => ({
  id: _constants.SecurityGroupName.assets,
  title: _link_groups.SecurityLinkGroup[_constants.SecurityGroupName.assets].title,
  renderAs: 'panelOpener',
  children: [{
    link: 'fleet',
    title: _i18n_strings.i18nStrings.assets.fleet.title,
    children: [{
      link: 'fleet:agents'
    }, {
      link: 'fleet:policies',
      title: _i18n_strings.i18nStrings.assets.fleet.policies
    }, {
      link: 'fleet:enrollment_tokens'
    }, {
      link: 'fleet:uninstall_tokens'
    }, {
      link: 'fleet:data_streams'
    }, {
      link: 'fleet:settings'
    }]
  }, {
    id: _constants.SecurityPageName.endpoints,
    title: _i18n_strings.i18nStrings.assets.endpoints.title,
    children: [{
      id: _constants.SecurityPageName.endpoints,
      link: (0, _links.securityLink)(_constants.SecurityPageName.endpoints),
      breadcrumbStatus: 'hidden'
    }, {
      id: _constants.SecurityPageName.policies,
      link: (0, _links.securityLink)(_constants.SecurityPageName.policies)
    }, {
      id: _constants.SecurityPageName.trustedApps,
      link: (0, _links.securityLink)(_constants.SecurityPageName.trustedApps)
    }, {
      id: _constants.SecurityPageName.eventFilters,
      link: (0, _links.securityLink)(_constants.SecurityPageName.eventFilters)
    }, {
      id: _constants.SecurityPageName.hostIsolationExceptions,
      link: (0, _links.securityLink)(_constants.SecurityPageName.hostIsolationExceptions)
    }, {
      id: _constants.SecurityPageName.blocklist,
      link: (0, _links.securityLink)(_constants.SecurityPageName.blocklist)
    }, {
      id: _constants.SecurityPageName.responseActionsHistory,
      link: (0, _links.securityLink)(_constants.SecurityPageName.responseActionsHistory)
    }]
  }, {
    children: [{
      renderItem: () => (0, _integrations_link_callout.renderIntegrationsLinkCallout)(core)
    }]
  }]
});
exports.createAssetsNavigationTree = createAssetsNavigationTree;