"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.contextDocumentHitMapper = void 0;
var _documents = require("@langchain/core/documents");
var _get_value_for_selected_field = require("./get_value_for_selected_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const contextDocumentHitMapper = contentField => hit => {
  let pageContent = '';
  const makePageContentForField = field => {
    const fieldValue = (0, _get_value_for_selected_field.getValueForSelectedField)(hit, field);
    return fieldValue.length > 0 ? `${field}: ${fieldValue}` : '';
  };
  if (typeof contentField === 'string') {
    pageContent = makePageContentForField(contentField);
  } else {
    const pageContentFieldKey = contentField[hit._index];
    if (typeof pageContentFieldKey === 'string') {
      pageContent = makePageContentForField(pageContentFieldKey);
    } else {
      pageContent = pageContentFieldKey.map(field => makePageContentForField(field)).filter(fieldContent => fieldContent.length > 0).join('\n');
    }
  }
  return new _documents.Document({
    pageContent,
    metadata: {
      _score: hit._score,
      _id: hit._id,
      _index: hit._index
    }
  });
};
exports.contextDocumentHitMapper = contextDocumentHitMapper;