"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchHomepageHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_asset_base_path = require("../hooks/use_asset_base_path");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchHomepageHeader = () => {
  const {
    euiTheme,
    colorMode
  } = (0, _eui.useEuiTheme)();
  const assetBasePath = (0, _use_asset_base_path.useAssetBasePath)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    "data-test-subj": "search-homepage-header",
    paddingSize: "none",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "stretch",
    style: {
      paddingLeft: euiTheme.size.xxxl,
      paddingRight: euiTheme.size.xxxl
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      alignSelf: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h1", null, _i18n.i18n.translate('xpack.searchHomepage.pageTitle', {
    defaultMessage: 'Your vector database just got faster'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.searchHomepage.description', {
    defaultMessage: 'Elasticsearch and Lucene now offer “Better binary quantization”, delivering ~95% memory reduction while maintaining high ranking quality.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    size: "xl",
    src: colorMode === 'LIGHT' ? `${assetBasePath}/search_homepage_light.svg` : `${assetBasePath}/search_homepage_dark.svg`,
    alt: ""
  }))));
};
exports.SearchHomepageHeader = SearchHomepageHeader;