"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFullPath = getFullPath;
exports.init = init;
exports.sendDelete = sendDelete;
exports.sendGet = sendGet;
exports.sendPost = sendPost;
exports.sendPut = sendPut;
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let _httpClient;
function init(httpClient) {
  _httpClient = httpClient;
}
function getFullPath(path) {
  if (path) {
    return `${_constants.API_BASE_PATH}/${path}`;
  }
  return _constants.API_BASE_PATH;
}
function sendPost(path, payload) {
  return _httpClient.post(getFullPath(path), {
    body: JSON.stringify(payload)
  });
}
function sendGet(path, {
  asSystemRequest
} = {}) {
  return _httpClient.get(getFullPath(path), {
    asSystemRequest
  });
}
function sendPut(path, payload) {
  return _httpClient.put(getFullPath(path), {
    body: JSON.stringify(payload)
  });
}
function sendDelete(path) {
  return _httpClient.delete(getFullPath(path));
}