"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAllResults = void 0;
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _helpers = require("../common/helpers");
var _kibana = require("../common/lib/kibana");
var _search_strategy = require("../../common/search_strategy");
var _use_error_toast = require("../common/hooks/use_error_toast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAllResults = ({
  actionId,
  activePage,
  startDate,
  limit,
  sort,
  kuery,
  skip = false,
  isLive = false
}) => {
  const {
    data
  } = (0, _kibana.useKibana)().services;
  const setErrorToast = (0, _use_error_toast.useErrorToast)();
  return (0, _reactQuery.useQuery)(['allActionResults', {
    actionId,
    activePage,
    limit,
    sort
  }], async () => {
    var _responseData$edges, _responseData$edges2;
    const responseData = await (0, _rxjs.lastValueFrom)(data.search.search({
      actionId,
      startDate,
      factoryQueryType: _search_strategy.OsqueryQueries.results,
      kuery,
      pagination: (0, _helpers.generateTablePaginationOptions)(activePage, limit),
      sort
    }, {
      strategy: 'osquerySearchStrategy'
    }));
    if (!(responseData !== null && responseData !== void 0 && (_responseData$edges = responseData.edges) !== null && _responseData$edges !== void 0 && _responseData$edges.length) && responseData !== null && responseData !== void 0 && responseData.total) {
      throw new Error('Empty edges while positive totalCount');
    }
    return {
      ...responseData,
      columns: Object.keys(((_responseData$edges2 = responseData.edges) === null || _responseData$edges2 === void 0 ? void 0 : _responseData$edges2.length) && responseData.edges[0].fields || {}).sort(),
      inspect: (0, _helpers.getInspectResponse)(responseData, {})
    };
  }, {
    keepPreviousData: true,
    refetchInterval: isLive ? 5000 : false,
    enabled: !skip,
    onSuccess: () => setErrorToast(),
    onError: error => setErrorToast(error, {
      title: _i18n.i18n.translate('xpack.osquery.results.fetchError', {
        defaultMessage: 'Error while fetching results'
      })
    })
  });
};
exports.useAllResults = useAllResults;