"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toExecutableAgent = exports.internalProviderToPublic = exports.createInternalRegistry = exports.createExecuteHandler = void 0;
var _combine_providers = require("./combine_providers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createInternalRegistry = ({
  providers,
  getRunner
}) => {
  const globalProvider = (0, _combine_providers.combineAgentProviders)(...providers);
  const publicRegistry = internalProviderToPublic({
    provider: globalProvider,
    getRunner
  });
  return Object.assign(globalProvider, {
    asPublicRegistry: () => publicRegistry
  });
};
exports.createInternalRegistry = createInternalRegistry;
const internalProviderToPublic = ({
  provider,
  getRunner
}) => {
  return {
    has(options) {
      return provider.has(options);
    },
    async get(options) {
      const agent = await provider.get(options);
      return toExecutableAgent({
        agent,
        getRunner,
        request: options.request
      });
    },
    async list(options) {
      const agents = await provider.list(options);
      return agents.map(agent => toExecutableAgent({
        agent,
        getRunner,
        request: options.request
      }));
    }
  };
};
exports.internalProviderToPublic = internalProviderToPublic;
const toExecutableAgent = ({
  agent,
  getRunner,
  request
}) => {
  return {
    type: agent.type,
    agentId: agent.id,
    providerId: agent.providerId,
    description: agent.description,
    execute: createExecuteHandler({
      agentId: agent.id,
      request,
      getRunner
    })
  };
};
exports.toExecutableAgent = toExecutableAgent;
const createExecuteHandler = ({
  agentId,
  request,
  getRunner
}) => {
  return params => {
    return getRunner().runAgent({
      ...params,
      agentId,
      request
    });
  };
};
exports.createExecuteHandler = createExecuteHandler;