"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountApp = void 0;
var _reactQuery = require("@tanstack/react-query");
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _public = require("@kbn/kibana-react-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _routes = require("./routes");
var _onechat_services_context = require("./context/onechat_services_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mountApp = async ({
  core,
  plugins,
  element,
  history,
  services
}) => {
  const kibanaServices = {
    ...core,
    plugins
  };
  const queryClient = new _reactQuery.QueryClient();
  _reactDom.default.render(core.rendering.addContext(/*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: kibanaServices
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_onechat_services_context.OnechatServicesContext.Provider, {
    value: services
  }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: core
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_routes.OnechatRoutes, null)))))))), element);
  return () => {
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.mountApp = mountApp;