"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnechatToolsTable = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_tools = require("../../hooks/use_tools");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const parseToolDescription = description => {
  // Truncate at newline
  const [truncatedDescription] = description.split('\n');
  return truncatedDescription;
};
const columns = [{
  field: 'id',
  name: _i18n.i18n.translate('xpack.onechat.tools.toolIdLabel', {
    defaultMessage: 'Tool'
  }),
  valign: 'top',
  render: id => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, id))
}, {
  field: 'description',
  name: _i18n.i18n.translate('xpack.onechat.tools.toolDescriptionLabel', {
    defaultMessage: 'Description'
  }),
  width: '60%',
  valign: 'top',
  render: description => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, parseToolDescription(description));
  }
}, {
  field: 'meta.tags',
  name: _i18n.i18n.translate('xpack.onechat.tools.tagsLabel', {
    defaultMessage: 'Tags'
  }),
  width: '15%',
  valign: 'top',
  render: tags => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, null, tags.map(tag => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      key: tag,
      color: "primary"
    }, tag)));
  }
}];
const OnechatToolsTable = () => {
  const {
    tools,
    isLoading,
    error
  } = (0, _use_tools.useOnechatTools)();
  const errorMessage = error ? _i18n.i18n.translate('xpack.onechat.tools.listToolsErrorMessage', {
    defaultMessage: 'Failed to fetch tools'
  }) : undefined;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    loading: isLoading,
    columns: columns,
    items: tools,
    itemId: "id",
    noItemsMessage: _i18n.i18n.translate('xpack.onechat.tools.noToolsMessage', {
      defaultMessage: 'No tools found'
    }),
    error: errorMessage
  });
};
exports.OnechatToolsTable = OnechatToolsTable;