"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = exports.completeRoutes = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _annotations = require("../pages/annotations/annotations");
var _date_picker_context = require("../context/date_picker_context/date_picker_context");
var _kibana_react = require("../utils/kibana_react");
var _alerts = require("../pages/alerts/alerts");
var _alert_details = require("../pages/alert_details/alert_details");
var _cases = require("../pages/cases/cases");
var _landing = require("../pages/landing/landing");
var _overview = require("../pages/overview/overview");
var _rules = require("../pages/rules/rules");
var _rule_details = require("../pages/rule_details/rule_details");
var _rule = require("../pages/rules/rule");
var _paths = require("../../common/locators/paths");
var _has_data_context = require("../context/has_data_context/has_data_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Note: React Router DOM <Redirect> component was not working here
// so I've recreated this simple version for this purpose.
function SimpleRedirect({
  to,
  redirectToApp
}) {
  const {
    application: {
      navigateToApp
    }
  } = (0, _kibana_react.useKibana)().services;
  const history = (0, _reactRouterDom.useHistory)();
  const {
    search,
    hash,
    pathname
  } = (0, _reactRouterDom.useLocation)();
  if (redirectToApp) {
    if (to === '/:sloId') {
      to = pathname.split('/slos')[1];
    }
    navigateToApp(redirectToApp, {
      path: `/${to}${search ? `?${search}` : ''}${hash}`,
      replace: true
    });
  } else if (to) {
    history.replace(to);
  }
  return null;
}
const completeRoutes = exports.completeRoutes = {
  [_paths.ROOT_PATH]: {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(SimpleRedirect, {
        to: _paths.OVERVIEW_PATH
      });
    },
    params: {},
    exact: true
  },
  [_paths.OVERVIEW_PATH]: {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(_has_data_context.HasDataContextProvider, null, /*#__PURE__*/_react.default.createElement(_date_picker_context.DatePickerContextProvider, null, /*#__PURE__*/_react.default.createElement(_overview.OverviewPage, null)));
    },
    params: {},
    exact: true
  }
};
const routes = exports.routes = {
  [_paths.LANDING_PATH]: {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(_has_data_context.HasDataContextProvider, null, /*#__PURE__*/_react.default.createElement(_landing.LandingPage, null));
    },
    params: {},
    exact: true
  },
  [_paths.CASES_PATH]: {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(_cases.CasesPage, null);
    },
    params: {},
    exact: false
  },
  [_paths.ALERTS_PATH]: {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(_alerts.AlertsPage, null);
    },
    params: {},
    exact: true
  },
  [_paths.EXPLORATORY_VIEW_PATH]: {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(SimpleRedirect, {
        to: "/",
        redirectToApp: "exploratory-view"
      });
    },
    params: {},
    exact: true
  },
  [_paths.RULES_PATH]: {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(_rules.RulesPage, null);
    },
    params: {},
    exact: true
  },
  [_paths.RULES_LOGS_PATH]: {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(_rules.RulesPage, {
        activeTab: "logs"
      });
    },
    params: {},
    exact: true
  },
  [_paths.RULE_DETAIL_PATH]: {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(_rule_details.RuleDetailsPage, null);
    },
    params: {},
    exact: true
  },
  [_paths.CREATE_RULE_PATH]: {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(_rule.RulePage, null);
    },
    params: {},
    exact: true
  },
  [_paths.EDIT_RULE_PATH]: {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(_rule.RulePage, null);
    },
    params: {},
    exact: true
  },
  [_paths.ALERT_DETAIL_PATH]: {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(_alert_details.AlertDetails, null);
    },
    params: {},
    exact: true
  },
  [_paths.OLD_SLOS_PATH]: {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(SimpleRedirect, {
        to: "/",
        redirectToApp: "slo"
      });
    },
    params: {},
    exact: true
  },
  [_paths.OLD_SLOS_WELCOME_PATH]: {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(SimpleRedirect, {
        to: "/welcome",
        redirectToApp: "slo"
      });
    },
    params: {},
    exact: true
  },
  [_paths.OLD_SLOS_OUTDATED_DEFINITIONS_PATH]: {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(SimpleRedirect, {
        to: "/outdated-definitions",
        redirectToApp: "slo"
      });
    },
    params: {},
    exact: true
  },
  [_paths.OLD_SLO_DETAIL_PATH]: {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(SimpleRedirect, {
        to: "/:sloId",
        redirectToApp: "slo"
      });
    },
    params: {},
    exact: true
  },
  [_paths.OLD_SLO_EDIT_PATH]: {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(SimpleRedirect, {
        to: "/:sloId",
        redirectToApp: "slo"
      });
    },
    params: {},
    exact: true
  },
  [_paths.ANNOTATIONS_PATH]: {
    handler: () => {
      return /*#__PURE__*/_react.default.createElement(_annotations.AnnotationsPage, null);
    },
    params: {},
    exact: true
  }
};