"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.emitWithConcatenatedMessage = emitWithConcatenatedMessage;
var _rxjs = require("rxjs");
var _conversation_complete = require("../conversation_complete");
var _concatenate_chat_completion_chunks = require("./concatenate_chat_completion_chunks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mergeWithEditedMessage(originalMessage, chunkEvent, callback) {
  return (0, _rxjs.from)((callback ? callback(originalMessage) : Promise.resolve(originalMessage)).then(message => {
    const next = {
      type: _conversation_complete.StreamingChatResponseEventType.MessageAdd,
      id: chunkEvent.id,
      message: {
        '@timestamp': new Date().toISOString(),
        ...message
      },
      // Preserve deanonymization data if present in the chunk event
      ...(chunkEvent.deanonymized_input && {
        deanonymized_input: chunkEvent.deanonymized_input
      }),
      ...(chunkEvent.deanonymized_output && {
        deanonymized_output: chunkEvent.deanonymized_output
      })
    };
    return next;
  }));
}
function filterChunkEvents() {
  return (0, _rxjs.filter)(event => event.type === _conversation_complete.StreamingChatResponseEventType.ChatCompletionChunk);
}
function emitWithConcatenatedMessage(callback) {
  return source$ => {
    const shared = source$.pipe((0, _rxjs.shareReplay)());
    const response$ = (0, _rxjs.concat)(shared, shared.pipe((0, _concatenate_chat_completion_chunks.concatenateChatCompletionChunks)(), (0, _rxjs.last)(), (0, _rxjs.withLatestFrom)(shared.pipe(filterChunkEvents())), (0, _rxjs.mergeMap)(([message, chunkEvent]) => {
      return mergeWithEditedMessage(message, chunkEvent, callback);
    })));
    return response$;
  };
}