"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createJobActionFocusRestoration = exports.createFocusRestoration = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates a function that restores focus to a trigger element after a delay.
 * Useful for modals that need time to close before focusing.
 * @param triggerElement - The element to focus when the function is called
 * @param delay - Delay in milliseconds before attempting to focus (default: 0)
 * @returns A function that restores focus to the trigger element
 */
const createFocusRestoration = (triggerElement, delay = 0) => {
  return () => {
    setTimeout(() => {
      if (triggerElement) {
        var _triggerElement$focus;
        (_triggerElement$focus = triggerElement.focus) === null || _triggerElement$focus === void 0 ? void 0 : _triggerElement$focus.call(triggerElement);
      }
    }, delay);
  };
};
exports.createFocusRestoration = createFocusRestoration;
const createJobActionFocusRestoration = jobId => {
  var _document$getElementB;
  const actionButton = (_document$getElementB = document.getElementById(`${jobId}-actions`)) === null || _document$getElementB === void 0 ? void 0 : _document$getElementB.querySelector('button');
  return createFocusRestoration(actionButton);
};
exports.createJobActionFocusRestoration = createJobActionFocusRestoration;