"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suppliedConfigurationsRouteFactory = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _resolvers = require("../../resolvers");
var _breadcrumbs = require("../../breadcrumbs");
var _page_header = require("../../../components/page_header");
var _locator = require("../../../../locator");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SuppliedConfigurations = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('../../../supplied_configurations/supplied_configurations')))).SuppliedConfigurations
}));
const suppliedConfigurationsRouteFactory = navigateToApp => ({
  id: 'supplied_configurations',
  path: (0, _router.createPath)(_locator.ML_PAGES.SUPPLIED_CONFIGURATIONS),
  title: _i18n.i18n.translate('xpack.ml.suppliedConfigurations.suppliedConfigurations.docTitle', {
    defaultMessage: 'Supplied configurations'
  }),
  render: () => /*#__PURE__*/_react.default.createElement(PageWrapper, null),
  breadcrumbs: [(0, _breadcrumbs.getStackManagementBreadcrumb)(navigateToApp), (0, _breadcrumbs.getMlManagementBreadcrumb)('ANOMALY_DETECTION_MANAGEMENT_BREADCRUMB', navigateToApp), (0, _breadcrumbs.getMlManagementBreadcrumb)('SUPPLIED_CONFIGURATIONS_MANAGEMENT_BREADCRUMB', navigateToApp)],
  enableDatePicker: false,
  'data-test-subj': 'mlPageSuppliedConfigurations'
});
exports.suppliedConfigurationsRouteFactory = suppliedConfigurationsRouteFactory;
const PageWrapper = () => {
  const {
    context
  } = (0, _use_resolver.useRouteResolver)('full', ['canGetJobs'], (0, _resolvers.basicResolvers)());
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    wrap: false,
    alignItems: 'flexStart',
    gutterSize: 'm',
    direction: "column",
    "data-test-subj": "mlPageSuppliedConfigurations"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.suppliedConfigurations.preconfigurecJobsHeader",
    defaultMessage: "Supplied configurations"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.suppliedConfigurations.preconfigurecJobsHeaderDescription",
    defaultMessage: "This page lists pre-defined anomaly detection job configurations with related Kibana assets."
  }))))), /*#__PURE__*/_react.default.createElement(SuppliedConfigurations, null));
};