"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InferenceInputForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _inference_base = require("../inference_base");
var _text_input = require("./text_input");
var _index_input = require("./index_input");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InferenceInputForm = ({
  inferrer,
  inputType
}) => {
  return inputType === _inference_base.INPUT_TYPE.TEXT ? /*#__PURE__*/_react.default.createElement(_text_input.TextInputForm, {
    inferrer: inferrer
  }) : /*#__PURE__*/_react.default.createElement(_index_input.IndexInputForm, {
    inferrer: inferrer
  });
};
exports.InferenceInputForm = InferenceInputForm;