"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validatePipelineId = validatePipelineId;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Validates a pipeline ID in Kibana API level.
 * Pipeline ID must begin with a letter or underscore and contain only letters, underscores, dashes, hyphens, and numbers
 * Note that, frontend already validates the pipeline ID on UI.
 */
function validatePipelineId(value) {
  const pipelineIdPattern = /^[A-Za-z_][A-Za-z0-9\-_]*$/;
  if (!pipelineIdPattern.test(value)) {
    return _i18n.i18n.translate('xpack.logstash.invalidPipelineIdErrorMessage', {
      defaultMessage: 'Pipeline ID must begin with a letter or underscore and contain only letters, underscores, dashes, hyphens, and numbers'
    });
  }
  return undefined;
}