"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serializeLinksAttributes = void 0;
var _persistable_state = require("../../common/persistable_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const serializeLinksAttributes = (state, shouldExtractReferences = true) => {
  var _state$links, _state$links$map;
  const linksToSave = (_state$links = state.links) === null || _state$links === void 0 ? void 0 : (_state$links$map = _state$links.map(({
    title,
    description,
    error,
    ...linkToSave
  }) => linkToSave)) === null || _state$links$map === void 0 ? void 0 : _state$links$map.map(
  // fiilter out null values which may have been introduced by the session state backup (undefined values are serialized as null).
  link => Object.fromEntries(Object.entries(link).filter(([key, value]) => value !== null)));
  const attributes = {
    title: state.defaultTitle,
    description: state.defaultDescription,
    layout: state.layout,
    links: linksToSave
  };
  const serializedState = shouldExtractReferences ? (0, _persistable_state.extractReferences)({
    attributes
  }) : {
    attributes,
    references: []
  };
  return serializedState;
};
exports.serializeLinksAttributes = serializeLinksAttributes;