"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToLensActionFactory = void 0;
var _public = require("@kbn/ui-actions-plugin/public");
var _public2 = require("@kbn/visualizations-plugin/public");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertToLensActionFactory = (id, displayName, originatingApp) => application => (0, _public.createAction)({
  type: _public2.ACTION_CONVERT_TO_LENS,
  id,
  getDisplayName: () => displayName,
  isCompatible: async () => !!application.capabilities.visualize_v2.show,
  execute: async context => {
    const table = Object.values(context.layers);
    const payload = {
      ...context,
      layers: table,
      isVisualizeAction: true
    };
    application.navigateToApp(_constants.APP_ID, {
      state: {
        type: _public2.ACTION_CONVERT_TO_LENS,
        payload,
        originatingApp
      }
    });
  }
});
exports.convertToLensActionFactory = convertToLensActionFactory;