"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlyoutWrapper = ({
  children,
  isInlineFlyoutVisible,
  isScrollable,
  displayFlyoutHeader,
  language,
  isNewPanel,
  isSaveable,
  onCancel,
  navigateToLensEditor,
  onApply,
  isReadOnly
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isInlineFlyoutVisible && displayFlyoutHeader && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    css: (0, _react2.css)`
            pointer-events: auto;
            background-color: ${_uiTheme.euiThemeVars.euiColorEmptyShade};
          `,
    "data-test-subj": "editFlyoutHeader"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "inlineEditingFlyoutLabel"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, _i18n.i18n.translate('xpack.lens.config.showVisualizationLabel', {
    defaultMessage: 'Configuration'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    title: _i18n.i18n.translate('xpack.lens.config.experimentalLabelDataview.title', {
      defaultMessage: 'Technical preview'
    }),
    content: _i18n.i18n.translate('xpack.lens.config.experimentalLabelDataview.content', {
      defaultMessage: 'Inline editing currently offers limited configuration options.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    tabIndex: 0,
    label: "",
    iconType: "beaker",
    size: "s",
    css: (0, _react2.css)`
                            vertical-align: middle;
                          `
  }))))))), navigateToLensEditor && !isReadOnly && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: navigateToLensEditor,
    "data-test-subj": "navigateToLensEditorLink"
  }, _i18n.i18n.translate('xpack.lens.config.editLinkLabel', {
    defaultMessage: 'Edit in Lens'
  })))))), isInlineFlyoutVisible && isReadOnly ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.lens.config.readOnly', {
      defaultMessage: 'Read-only: Changes will be reverted on close'
    }),
    color: "warning",
    iconType: "warning",
    size: "s"
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    className: "lnsEditFlyoutBody",
    css: (0, _react2.css)`
          // styles needed to display extra drop targets that are outside of the config panel main area
          overflow-y: auto;
          padding-left: ${_uiTheme.euiThemeVars.euiFormMaxWidth};
          margin-left: -${_uiTheme.euiThemeVars.euiFormMaxWidth};
          pointer-events: none;
          .euiFlyoutBody__overflow {
            transform: initial;
            -webkit-mask-image: none;
            padding-left: inherit;
            margin-left: inherit;
            ${!isScrollable && `
                overflow-y: hidden;
              `}
            > * {
              pointer-events: auto;
            }
          }
          .euiFlyoutBody__overflowContent {
            padding: 0;
          }
        `
  }, children), isInlineFlyoutVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    id: "lnsCancelEditOnFlyFlyout",
    onClick: onCancel,
    flush: "left",
    "aria-label": _i18n.i18n.translate('xpack.lens.config.cancelFlyoutAriaLabel', {
      defaultMessage: 'Cancel applied changes'
    }),
    "data-test-subj": "cancelFlyoutButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.config.cancelFlyoutLabel",
    defaultMessage: "Cancel"
  }))), isReadOnly ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onApply,
    fill: true,
    disabled: Boolean(isNewPanel) ? false : !isSaveable,
    iconType: "check",
    "data-test-subj": "applyFlyoutButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.config.applyFlyoutLabel",
    defaultMessage: "Apply and close"
  }))))));
};
exports.FlyoutWrapper = FlyoutWrapper;