"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _constants = require("../../../common/constants");
var _api_privileges = require("../../constants/api_privileges");
var _constants2 = require("../../constants");
var _types = require("../../types");
var _handler = require("./handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = router => {
  router.versioned.post({
    path: _constants2.PRECONFIGURATION_API_ROUTES.RESET_PATTERN,
    access: 'public',
    security: {
      authz: {
        requiredPrivileges: [_api_privileges.FLEET_API_PRIVILEGES.AGENTS.ALL, _api_privileges.FLEET_API_PRIVILEGES.AGENT_POLICIES.ALL, _api_privileges.FLEET_API_PRIVILEGES.SETTINGS.ALL, _api_privileges.FLEET_API_PRIVILEGES.INTEGRATIONS.READ]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: false
  }, _handler.resetPreconfigurationHandler);
  router.versioned.post({
    path: _constants2.PRECONFIGURATION_API_ROUTES.RESET_ONE_PATTERN,
    access: 'public',
    security: {
      authz: {
        requiredPrivileges: [_api_privileges.FLEET_API_PRIVILEGES.AGENTS.ALL, _api_privileges.FLEET_API_PRIVILEGES.AGENT_POLICIES.ALL, _api_privileges.FLEET_API_PRIVILEGES.SETTINGS.ALL, _api_privileges.FLEET_API_PRIVILEGES.INTEGRATIONS.READ]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PostResetOnePreconfiguredAgentPoliciesSchema
    }
  }, _handler.resetOnePreconfigurationHandler);
};
exports.registerRoutes = registerRoutes;