"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _constants = require("../../constants");
var _constants2 = require("../../../common/constants");
var _api_privileges = require("../../constants/api_privileges");
var _debug = require("../../types/rest_spec/debug");
var _handler = require("./handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = router => {
  router.versioned.post({
    path: _constants.FLEET_DEBUG_ROUTES.INDEX_PATTERN,
    access: 'internal',
    security: {
      authz: {
        requiredPrivileges: [_api_privileges.FLEET_API_PRIVILEGES.AGENTS.ALL, _api_privileges.FLEET_API_PRIVILEGES.AGENT_POLICIES.ALL, _api_privileges.FLEET_API_PRIVILEGES.SETTINGS.ALL]
      }
    }
  }).addVersion({
    version: _constants2.API_VERSIONS.internal.v1,
    validate: {
      request: _debug.FetchIndexRequestSchema
    }
  }, _handler.fetchIndexHandler);
  router.versioned.post({
    path: _constants.FLEET_DEBUG_ROUTES.SAVED_OBJECTS_PATTERN,
    access: 'internal',
    security: {
      authz: {
        requiredPrivileges: [_api_privileges.FLEET_API_PRIVILEGES.AGENTS.ALL, _api_privileges.FLEET_API_PRIVILEGES.AGENT_POLICIES.ALL, _api_privileges.FLEET_API_PRIVILEGES.SETTINGS.ALL]
      }
    }
  }).addVersion({
    version: _constants2.API_VERSIONS.internal.v1,
    validate: {
      request: _debug.FetchSavedObjectsRequestSchema
    }
  }, _handler.fetchSavedObjectsHandler);
  router.versioned.post({
    path: _constants.FLEET_DEBUG_ROUTES.SAVED_OBJECT_NAMES_PATTERN,
    access: 'internal',
    security: {
      authz: {
        requiredPrivileges: [_api_privileges.FLEET_API_PRIVILEGES.AGENTS.ALL, _api_privileges.FLEET_API_PRIVILEGES.AGENT_POLICIES.ALL, _api_privileges.FLEET_API_PRIVILEGES.SETTINGS.ALL]
      }
    }
  }).addVersion({
    version: _constants2.API_VERSIONS.internal.v1,
    validate: {
      request: _debug.FetchSavedObjectNamesRequestSchema
    }
  }, _handler.fetchSavedObjectNamesHandler);
};
exports.registerRoutes = registerRoutes;