"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackageListGrid = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../hooks");
var _utils = require("../utils");
var _controls = require("./controls");
var _grid = require("./grid");
var _missing_integrations = require("./missing_integrations");
var _search_box = require("./search_box");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StickySidebar = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  position: sticky;
  top: 120px;
`;
const PackageListGrid = ({
  isLoading,
  controls,
  emptyStateStyles,
  title,
  list,
  searchTerm,
  setSearchTerm,
  selectedCategory,
  setCategory,
  categories,
  availableSubCategories,
  setSelectedSubCategory,
  selectedSubCategory,
  setUrlandReplaceHistory,
  setUrlandPushHistory,
  showMissingIntegrationMessage = false,
  sortByFeaturedIntegrations = true,
  callout,
  calloutTopSpacerSize = 'l',
  // Default EUI spacer size
  showCardLabels = true,
  showControls = true,
  showSearchTools = true,
  spacer = true,
  scrollElementId
}) => {
  const euiTheme = (0, _eui.useEuiTheme)();
  const localSearch = (0, _hooks.useLocalSearch)(list, !!isLoading);
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const MAX_SUBCATEGORIES_NUMBER = 6;
  const onButtonClick = () => {
    setPopover(!isPopoverOpen);
  };
  const closePopover = () => {
    setPopover(false);
  };
  const resetQuery = () => {
    setSearchTerm('');
    setUrlandReplaceHistory({
      searchString: '',
      categoryId: '',
      subCategoryId: ''
    });
  };
  const onSubCategoryClick = (0, _react.useCallback)(subCategory => {
    if (setSelectedSubCategory) setSelectedSubCategory(subCategory);
    setUrlandPushHistory({
      categoryId: selectedCategory,
      subCategoryId: subCategory
    });
  }, [selectedCategory, setSelectedSubCategory, setUrlandPushHistory]);
  const filteredPromotedList = (0, _react.useMemo)(() => {
    var _map;
    if (isLoading) return [];
    const searchResults = (_map = (localSearch === null || localSearch === void 0 ? void 0 : localSearch.search(searchTerm)).map(match => match[_hooks.searchIdField])) !== null && _map !== void 0 ? _map : [];
    const filteredList = searchTerm ? list.filter(item => {
      var _searchResults$includ;
      return (_searchResults$includ = searchResults.includes(item[_hooks.searchIdField])) !== null && _searchResults$includ !== void 0 ? _searchResults$includ : [];
    }) : list;
    return sortByFeaturedIntegrations ? (0, _utils.promoteFeaturedIntegrations)(filteredList, selectedCategory) : filteredList;
  }, [isLoading, list, localSearch, searchTerm, selectedCategory, sortByFeaturedIntegrations]);
  const splitSubcategories = subcategories => {
    if (!subcategories) return {};else if (subcategories && (subcategories === null || subcategories === void 0 ? void 0 : subcategories.length) < MAX_SUBCATEGORIES_NUMBER) {
      return {
        visibleSubCategories: subcategories,
        hiddenSubCategories: []
      };
    } else if (subcategories && (subcategories === null || subcategories === void 0 ? void 0 : subcategories.length) >= MAX_SUBCATEGORIES_NUMBER) {
      return {
        visibleSubCategories: subcategories.slice(0, MAX_SUBCATEGORIES_NUMBER),
        hiddenSubCategories: subcategories.slice(MAX_SUBCATEGORIES_NUMBER)
      };
    }
    return {};
  };
  const splitSubcat = splitSubcategories(availableSubCategories);
  const {
    visibleSubCategories
  } = splitSubcat;
  const hiddenSubCategoriesItems = (0, _react.useMemo)(() => {
    var _splitSubcat$hiddenSu;
    return splitSubcat === null || splitSubcat === void 0 ? void 0 : (_splitSubcat$hiddenSu = splitSubcat.hiddenSubCategories) === null || _splitSubcat$hiddenSu === void 0 ? void 0 : _splitSubcat$hiddenSu.map(subCategory => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: subCategory.id,
        onClick: () => {
          onSubCategoryClick(subCategory.id);
          closePopover();
        },
        icon: selectedSubCategory === subCategory.id ? 'check' : 'empty'
      }, subCategory.title);
    });
  }, [onSubCategoryClick, selectedSubCategory, splitSubcat === null || splitSubcat === void 0 ? void 0 : splitSubcat.hiddenSubCategories]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "flexStart",
    gutterSize: "xl",
    "data-test-subj": "epmList.integrationCards"
  }, showControls && /*#__PURE__*/_react.default.createElement(StickySidebar, {
    "data-test-subj": "epmList.controlsSideColumn",
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_controls.ControlsColumn, {
    controls: controls,
    title: title
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5,
    "data-test-subj": "epmList.mainColumn",
    style: {
      position: 'relative',
      backgroundColor: euiTheme.euiTheme.colors.backgroundBasePlain,
      alignSelf: 'stretch'
    }
  }, showSearchTools && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_search_box.SearchBox, {
    searchTerm: searchTerm,
    setSearchTerm: setSearchTerm,
    selectedCategory: selectedCategory,
    setCategory: setCategory,
    categories: categories,
    availableSubCategories: availableSubCategories,
    setSelectedSubCategory: setSelectedSubCategory,
    selectedSubCategory: selectedSubCategory,
    setUrlandReplaceHistory: setUrlandReplaceHistory
  })), availableSubCategories !== null && availableSubCategories !== void 0 && availableSubCategories.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "epmList.subcategoriesRow",
    justifyContent: "flexStart",
    direction: "row",
    gutterSize: "s",
    style: {
      maxWidth: 943
    }
  }, visibleSubCategories === null || visibleSubCategories === void 0 ? void 0 : visibleSubCategories.map(subCategory => {
    const isSelected = subCategory.id === selectedSubCategory;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: subCategory.id
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      css: isSelected ? 'color: white' : '',
      color: isSelected ? 'accent' : 'text',
      fill: isSelected,
      "aria-label": subCategory === null || subCategory === void 0 ? void 0 : subCategory.title,
      onClick: () => onSubCategoryClick(subCategory.id)
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmList.subcategoriesButton",
      defaultMessage: "{subcategory}",
      values: {
        subcategory: subCategory.title
      }
    })));
  }), hiddenSubCategoriesItems !== null && hiddenSubCategoriesItems !== void 0 && hiddenSubCategoriesItems.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "epmList.showMoreSubCategoriesButton",
    id: "moreSubCategories",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      display: "base",
      onClick: onButtonClick,
      iconType: "boxesHorizontal",
      "aria-label": "Show more subcategories",
      size: "m"
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: hiddenSubCategoriesItems
  }))) : null)), callout ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: calloutTopSpacerSize
  }), callout) : null, spacer && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_grid.GridColumn, {
    emptyStateStyles: emptyStateStyles,
    isLoading: !!isLoading,
    list: filteredPromotedList,
    showMissingIntegrationMessage: showMissingIntegrationMessage,
    showCardLabels: showCardLabels,
    scrollElementId: scrollElementId
  })), showMissingIntegrationMessage && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_missing_integrations.MissingIntegrationContent, {
    setUrlandPushHistory: setUrlandPushHistory,
    resetQuery: resetQuery,
    setSelectedCategory: setCategory
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null))));
};
exports.PackageListGrid = PackageListGrid;