"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputFormRemoteEsSection = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _multi_row_input = require("../multi_row_input");
var _services = require("../../../../services");
var _hooks = require("../../../../hooks");
var _output_form_secret_form_row = require("./output_form_secret_form_row");
var _ssl_form_section = require("./ssl_form_section");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OutputFormRemoteEsSection = props => {
  const {
    docLinks,
    cloud
  } = (0, _hooks.useStartServices)();
  const {
    inputs,
    useSecretsStorage,
    onToggleSecretStorage
  } = props;
  const [isConvertedToSecret, setIsConvertedToSecret] = _react.default.useState({
    serviceToken: false,
    kibanaAPIKey: false,
    sslKey: false
  });
  const {
    enableSyncIntegrationsOnRemote,
    enableSSLSecrets
  } = _services.ExperimentalFeaturesService.get();
  const enableSyncIntegrations = enableSyncIntegrationsOnRemote && _hooks.licenseService.isEnterprise() && !(cloud !== null && cloud !== void 0 && cloud.isServerlessEnabled);
  const [isRemoteClusterInstructionsOpen, setIsRemoteClusterInstructionsOpen] = _react.default.useState(false);
  const [isFirstLoad, setIsFirstLoad] = _react.default.useState(true);
  (0, _react.useEffect)(() => {
    if (!isFirstLoad) return;
    setIsFirstLoad(false);
    // populate the secret input with the value of the plain input in order to re-save the output with secret storage
    if (useSecretsStorage) {
      let isServiceTokenSecret = false;
      if (inputs.serviceTokenInput.value && !inputs.serviceTokenSecretInput.value) {
        inputs.serviceTokenSecretInput.setValue(inputs.serviceTokenInput.value);
        inputs.serviceTokenInput.clear();
        isServiceTokenSecret = true;
      }
      let isSslKeySecretInput = false;
      if (enableSSLSecrets) {
        if (inputs.sslKeyInput.value && !inputs.sslKeySecretInput.value) {
          inputs.sslKeySecretInput.setValue(inputs.sslKeyInput.value);
          inputs.sslKeyInput.clear();
          isSslKeySecretInput = true;
        }
      }
      setIsConvertedToSecret({
        ...isConvertedToSecret,
        serviceToken: isServiceTokenSecret,
        sslKey: isSslKeySecretInput
      });
    }
  }, [useSecretsStorage, inputs.serviceTokenInput, inputs.serviceTokenSecretInput, inputs.kibanaAPIKeyInput, isFirstLoad, setIsFirstLoad, isConvertedToSecret, inputs.sslKeyInput, inputs.sslKeySecretInput, enableSSLSecrets]);
  const onToggleSecretAndClearValue = secretEnabled => {
    if (secretEnabled) {
      inputs.serviceTokenInput.clear();
      inputs.kibanaAPIKeyInput.clear();
      if (enableSSLSecrets) inputs.sslKeyInput.clear();
    } else {
      inputs.serviceTokenSecretInput.setValue('');
      if (enableSSLSecrets) inputs.sslKeyInput.setValue('');
    }
    setIsConvertedToSecret({
      ...isConvertedToSecret,
      serviceToken: false,
      kibanaAPIKey: false,
      sslKey: false
    });
    onToggleSecretStorage(secretEnabled);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_multi_row_input.MultiRowInput, (0, _extends2.default)({
    "data-test-subj": "settingsOutputsFlyout.hostUrlInput",
    label: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.remoteEsHostsInputLabel', {
      defaultMessage: 'Hosts'
    }),
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.remoteEsHostsInputPlaceholder', {
      defaultMessage: 'Specify host URL'
    })
  }, inputs.elasticsearchUrlInput.props, {
    isUrl: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), !useSecretsStorage ? /*#__PURE__*/_react.default.createElement(_output_form_secret_form_row.SecretFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.serviceTokenLabel",
      defaultMessage: "Service token"
    })
  }, inputs.serviceTokenInput.formRowProps, {
    useSecretsStorage: useSecretsStorage,
    onToggleSecretStorage: onToggleSecretAndClearValue
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    fullWidth: true,
    "data-test-subj": "serviceTokenSecretInput"
  }, inputs.serviceTokenInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.remoteESHostPlaceholder', {
      defaultMessage: 'Specify service token'
    })
  }))) : /*#__PURE__*/_react.default.createElement(_output_form_secret_form_row.SecretFormRow, (0, _extends2.default)({
    fullWidth: true,
    title: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.serviceTokenLabel', {
      defaultMessage: 'Service token'
    })
  }, inputs.serviceTokenSecretInput.formRowProps, {
    cancelEdit: inputs.serviceTokenSecretInput.cancelEdit,
    useSecretsStorage: useSecretsStorage,
    isConvertedToSecret: isConvertedToSecret.serviceToken,
    onToggleSecretStorage: onToggleSecretAndClearValue
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    "data-test-subj": "serviceTokenSecretInput",
    fullWidth: true
  }, inputs.serviceTokenSecretInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.remoteESHostPlaceholder', {
      defaultMessage: 'Specify service token'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.serviceTokenCalloutText",
      defaultMessage: "Generate a service token by running this API request in the remote Kibana Console and copy the response value"
    }),
    "data-test-subj": "serviceTokenCallout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true
  }, `POST kbn:/api/fleet/service_tokens
{
  "remote": true
}`)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_ssl_form_section.SSLFormSection, {
    type: inputs.typeInput.value,
    inputs: inputs,
    useSecretsStorage: enableSSLSecrets && useSecretsStorage,
    isConvertedToSecret: isConvertedToSecret.sslKey,
    onToggleSecretAndClearValue: onToggleSecretAndClearValue
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), enableSyncIntegrations ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.syncIntegrationsFormRowLabel",
      defaultMessage: "If enabled, integration assets will be installed on the remote Elasticsearch cluster"
    })
  }, inputs.syncIntegrationsInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({}, inputs.syncIntegrationsInput.props, {
    "data-test-subj": "syncIntegrationsSwitch",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.syncIntegrationsSwitchLabel",
      defaultMessage: "Synchronize integrations"
    })
  }))), inputs.syncIntegrationsInput.value === true && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.syncUninstalledIntegrationsFormRowLabel",
      defaultMessage: "If enabled, uninstalled integrations will also be uninstalled on the remote Elasticsearch cluster"
    })
  }, inputs.syncUninstalledIntegrationsInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({}, inputs.syncUninstalledIntegrationsInput.props, {
    "data-test-subj": "syncUninstalledIntegrationsSwitch",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.syncUninstalledIntegrationsSwitchLabel",
      defaultMessage: "Uninstall integrations on remote"
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "info",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.remoteClusterConfigurationCalloutTitle",
      defaultMessage: "Additional remote cluster configuration required"
    }),
    "data-test-subj": "remoteClusterConfigurationCallout"
  }, isRemoteClusterInstructionsOpen ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => setIsRemoteClusterInstructionsOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.remoteClusterConfiguration.collapseInstructionsButtonLabel",
    defaultMessage: "Collapse steps"
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => setIsRemoteClusterInstructionsOpen(true),
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.remoteClusterConfiguration.viewInstructionButtonLabel",
    defaultMessage: "View steps"
  })), isRemoteClusterInstructionsOpen && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.remoteClusterConfiguration.description",
    defaultMessage: "To sync integrations from this cluster, the remote Elasticsearch output needs additional configuration. {documentationLink}.",
    values: {
      documentationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        href: docLinks.links.fleet.remoteESOoutput
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.settings.remoteClusterConfiguration.documentationLink",
        defaultMessage: "Learn more"
      }))
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("ol", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.remoteClusterConfiguration.addRemoteClusterStep",
    defaultMessage: "In the remote cluster, open Kibana and go to {appPath}, and follow the steps to add this cluster.",
    values: {
      appPath: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.settings.remoteClusterConfiguration.addRemoteClusterKibanaPath",
        defaultMessage: "Stack Management > Remote Clusters"
      }))
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.remoteClusterConfiguration.replicationStep",
    defaultMessage: "Go to {appPath} and create a follower index using the cluster from Step 1. The leader index is {leaderIndex} from this cluster and should be replicated to the follower index {followerIndex} on the remote cluster.",
    values: {
      appPath: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.settings.remoteClusterConfiguration.replicationKibanaPath",
        defaultMessage: "Stack Management > Cross-Cluster Replication"
      })),
      leaderIndex: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "fleet-synced-integrations"),
      followerIndex: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "fleet-synced-integrations-ccr-", (0, _lodash.snakeCase)(inputs.nameInput.props.value) || '<output name>')
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.remoteClusterConfiguration.configureKibanaStep",
    defaultMessage: "Below, provide the access details for the remote cluster's Kibana instance."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.remoteClusterConfiguration.ccsDescription",
    defaultMessage: "To search accross remote clusters from this cluster, see the {prerequisites}. Once the remote cluster is added, CCS Data Views will be created automatically.",
    values: {
      prerequisites: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: `${docLinks.links.ccs.guide}#_prerequisites`
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.settings.remoteClusterConfiguration.ccsDocumentationLink",
        defaultMessage: "CCS prerequisites"
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kibanaURLInputLabel",
      defaultMessage: "Remote Kibana URL"
    })
  }, inputs.kibanaURLInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    "data-test-subj": "settingsOutputsFlyout.kibanaURLInput",
    fullWidth: true
  }, inputs.kibanaURLInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.kibanaURLInputPlaceholder', {
      defaultMessage: 'Specify Kibana URL'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kibanaAPIKeyLabel",
      defaultMessage: "Remote Kibana API Key"
    })
  }, inputs.kibanaAPIKeyInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, (0, _extends2.default)({
    fullWidth: true,
    type: "dual",
    "data-test-subj": "kibanaAPIKeySecretInput"
  }, inputs.kibanaAPIKeyInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.kibanaAPIKeyPlaceholder', {
      defaultMessage: 'Specify encoded Kibana API Key'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kibanaAPIKeyCalloutText",
      defaultMessage: "Create an API Key by running this API request in the remote Kibana Console and copy the encoded value"
    }),
    "data-test-subj": "kibanaAPIKeyCallout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true
  }, ` POST /_security/api_key
   {
     "name": "integration_sync_api_key",
     "role_descriptors": {
       "integration_writer": {
         "cluster": [],
        "indices":[],
        "applications": [{
           "application": "kibana-.kibana",
             "privileges": ["feature_fleet.read", "feature_fleetv2.read"],
             "resources": ["*"]
         }]
        }
     }
   }`)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }))) : null);
};
exports.OutputFormRemoteEsSection = OutputFormRemoteEsSection;