"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AGENT_STATUSES = void 0;
exports.getColorForAgentStatus = getColorForAgentStatus;
exports.getLabelForAgentStatus = getLabelForAgentStatus;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AGENT_STATUSES = exports.AGENT_STATUSES = ['healthy', 'unhealthy', 'orphaned', 'updating', 'offline', 'inactive', 'unenrolled', 'uninstalled'];
function getColorForAgentStatus(agentStatus, euiTheme) {
  const isAmsterdam = euiTheme.themeName === 'EUI_THEME_AMSTERDAM';
  switch (agentStatus) {
    case 'healthy':
      return isAmsterdam ? euiTheme.colors.vis.euiColorVisBehindText0 : euiTheme.colors.backgroundFilledSuccess;
    case 'offline':
      return euiTheme.colors.lightShade;
    case 'inactive':
      return euiTheme.colors.darkShade;
    case 'unhealthy':
      return isAmsterdam ? euiTheme.colors.vis.euiColorVisBehindText5 : euiTheme.colors.backgroundFilledWarning;
    case 'orphaned':
      return isAmsterdam ? euiTheme.colors.vis.euiColorVisBehindText5 : euiTheme.colors.backgroundFilledWarning;
    case 'updating':
      return isAmsterdam ? euiTheme.colors.vis.euiColorVisBehindText1 : euiTheme.colors.backgroundFilledPrimary;
    case 'unenrolled':
      return euiTheme.colors.backgroundBaseDisabled;
    case 'uninstalled':
      return euiTheme.colors.lightShade;
    default:
      throw new Error(`Unsupported Agent status ${agentStatus}`);
  }
}
function getLabelForAgentStatus(agentStatus) {
  switch (agentStatus) {
    case 'healthy':
      return _i18n.i18n.translate('xpack.fleet.agentStatus.healthyLabel', {
        defaultMessage: 'Healthy'
      });
    case 'offline':
      return _i18n.i18n.translate('xpack.fleet.agentStatus.offlineLabel', {
        defaultMessage: 'Offline'
      });
    case 'uninstalled':
      return _i18n.i18n.translate('xpack.fleet.agentStatus.uninstalledLabel', {
        defaultMessage: 'Uninstalled'
      });
    case 'inactive':
      return _i18n.i18n.translate('xpack.fleet.agentStatus.inactiveLabel', {
        defaultMessage: 'Inactive'
      });
    case 'unenrolled':
      return _i18n.i18n.translate('xpack.fleet.agentStatus.unenrolledLabel', {
        defaultMessage: 'Unenrolled'
      });
    case 'unhealthy':
      return _i18n.i18n.translate('xpack.fleet.agentStatus.unhealthyLabel', {
        defaultMessage: 'Unhealthy'
      });
    case 'orphaned':
      return _i18n.i18n.translate('xpack.fleet.agentStatus.orphanedLabel', {
        defaultMessage: 'Orphaned'
      });
    case 'updating':
      return _i18n.i18n.translate('xpack.fleet.agentStatus.updatingLabel', {
        defaultMessage: 'Updating'
      });
    default:
      throw new Error(`Unsupported Agent status ${agentStatus}`);
  }
}