"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentStatusBadges = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _agent_status = require("../../services/agent_status");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentStatusBadges = exports.AgentStatusBadges = /*#__PURE__*/(0, _react.memo)(({
  agentStatus
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, _agent_status.AGENT_STATUSES.map(status => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: status,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(AgentStatusBadge, {
    status: status,
    count: agentStatus[status] || 0
  }))));
});
const AgentStatusBadge = /*#__PURE__*/(0, _react.memo)(({
  status,
  count
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: (0, _agent_status.getColorForAgentStatus)(status, euiTheme)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, (0, _agent_status.getLabelForAgentStatus)(status)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    size: "s",
    color: "subdued"
  }, count)))));
});