"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.apmFieldFormats = void 0;
var _elasticsearch_fieldnames = require("../constants/elasticsearch_fieldnames");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const apmFieldFormats = exports.apmFieldFormats = [{
  field: _elasticsearch_fieldnames.TRANSACTION_DURATION,
  format: {
    id: 'duration',
    params: {
      inputFormat: 'microseconds',
      outputFormat: 'asMilliseconds',
      outputPrecision: 0,
      showSuffix: true,
      useShortSuffix: true
    }
  }
}, {
  field: _elasticsearch_fieldnames.METRIC_SYSTEM_MEMORY_USAGE,
  format: {
    id: 'bytes',
    params: {}
  }
}, {
  field: _elasticsearch_fieldnames.METRIC_SYSTEM_CPU_USAGE,
  format: {
    id: 'percent',
    params: {}
  }
}];