"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CronYearly = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const CronYearly = ({
  minute,
  minuteOptions,
  hour,
  hourOptions,
  date,
  dateOptions,
  month,
  monthOptions,
  onChange
}) => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "esUi.cronEditor.cronYearly.fieldMonthLabel",
    defaultMessage: "Month"
  }),
  fullWidth: true,
  "data-test-subj": "cronFrequencyConfiguration"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
  options: monthOptions,
  value: month,
  onChange: e => onChange({
    month: e.target.value
  }),
  fullWidth: true,
  prepend: _i18n.i18n.translate('esUi.cronEditor.cronYearly.fieldMonth.textInLabel', {
    defaultMessage: 'In'
  }),
  "data-test-subj": "cronFrequencyYearlyMonthSelect"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "esUi.cronEditor.cronYearly.fieldDateLabel",
    defaultMessage: "Date"
  }),
  fullWidth: true,
  "data-test-subj": "cronFrequencyConfiguration"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
  options: dateOptions,
  value: date,
  onChange: e => onChange({
    date: e.target.value
  }),
  fullWidth: true,
  prepend: _i18n.i18n.translate('esUi.cronEditor.cronYearly.fieldDate.textOnTheLabel', {
    defaultMessage: 'On the'
  }),
  "data-test-subj": "cronFrequencyYearlyDateSelect"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "esUi.cronEditor.cronYearly.fieldTimeLabel",
    defaultMessage: "Time"
  }),
  fullWidth: true,
  "data-test-subj": "cronFrequencyConfiguration"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "xs"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
  options: hourOptions,
  value: hour,
  "aria-label": _i18n.i18n.translate('esUi.cronEditor.cronYearly.hourSelectLabel', {
    defaultMessage: 'Hour'
  }),
  onChange: e => onChange({
    hour: e.target.value
  }),
  fullWidth: true,
  prepend: _i18n.i18n.translate('esUi.cronEditor.cronYearly.fieldHour.textAtLabel', {
    defaultMessage: 'At'
  }),
  "data-test-subj": "cronFrequencyYearlyHourSelect"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
  options: minuteOptions,
  value: minute,
  "aria-label": _i18n.i18n.translate('esUi.cronEditor.cronYearly.minuteSelectLabel', {
    defaultMessage: 'Minute'
  }),
  onChange: e => onChange({
    minute: e.target.value
  }),
  fullWidth: true,
  prepend: ":",
  "data-test-subj": "cronFrequencyYearlyMinuteSelect"
})))));
exports.CronYearly = CronYearly;