"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTotalCountRequestParams = exports.getPaginationRequestSizeParams = exports.getPaginationRequestParams = exports.getBaseSearchTemplate = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSearchQueryRequestParams = (field, search) => {
  const createRegexQuery = queryString => {
    const query = queryString.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, '\\$&');
    return `.*${query}.*`;
  };
  return {
    regexp: {
      [field]: {
        value: createRegexQuery(search)
      }
    }
  };
};
const getTotalCountRequestParams = field => ({
  totalCount: {
    cardinality: {
      field
    }
  }
});
exports.getTotalCountRequestParams = getTotalCountRequestParams;
const getPaginationRequestSizeParams = (pageIndex, pageSize) => ({
  size: (pageIndex + 1) * pageSize
});
exports.getPaginationRequestSizeParams = getPaginationRequestSizeParams;
const getPaginationRequestParams = (pageIndex, pageSize) => ({
  aggs: {
    sort: {
      bucket_sort: {
        from: pageIndex * pageSize,
        size: pageSize
      }
    }
  }
});
exports.getPaginationRequestParams = getPaginationRequestParams;
const getBaseSearchTemplate = (dataView, aggregationFieldName, {
  search,
  timeRange,
  eventType
}, aggs) => ({
  params: {
    index: dataView.title,
    aggs,
    query: {
      bool: {
        must: [{
          range: {
            '@timestamp': {
              gte: timeRange.from,
              lt: timeRange.to
            }
          }
        }, ...(eventType ? [{
          term: {
            'event.action': eventType
          }
        }] : []), ...(search ? [getSearchQueryRequestParams(aggregationFieldName, search)] : [])]
      }
    },
    size: 0,
    track_total_hits: false
  }
});
exports.getBaseSearchTemplate = getBaseSearchTemplate;