"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAttackDiscoveriesGenerationSchema = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAttackDiscoveriesGenerationSchema = prompts => _zod.z.object({
  insights: _zod.z.array(_zod.z.object({
    alertIds: _zod.z.string().array().describe(`The alert IDs that the insight is based on.`),
    detailsMarkdown: _zod.z.string().describe(prompts.detailsMarkdown),
    entitySummaryMarkdown: _zod.z.string().optional().describe(prompts.entitySummaryMarkdown),
    mitreAttackTactics: _zod.z.string().array().optional().describe(prompts.mitreAttackTactics),
    summaryMarkdown: _zod.z.string().describe(prompts.summaryMarkdown),
    title: _zod.z.string().describe(prompts.title)
  })).describe(prompts.insights)
});
exports.getAttackDiscoveriesGenerationSchema = getAttackDiscoveriesGenerationSchema;