"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigationProps = void 0;
var _react = require("react");
var _esQuery = require("@kbn/es-query");
var _reactRouterDom = require("react-router-dom");
var _use_discover_services = require("./use_discover_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getStateParams = ({
  isEmbeddableView,
  columns,
  filters,
  filterManager,
  data,
  savedSearchId
}) => {
  let appliedFilters = [];
  let query;
  let timeRange;
  if (!isEmbeddableView) {
    // applied from discover main and context app
    appliedFilters = [...filterManager.getGlobalFilters(), ...filterManager.getAppFilters()];
    query = data.query.queryString.getQuery();
    timeRange = data.query.timefilter.timefilter.getTime();
  } else if (isEmbeddableView && filters !== null && filters !== void 0 && filters.length) {
    // applied from saved search embeddable
    appliedFilters = filters;
  }
  return {
    columns,
    query,
    timeRange,
    filters: appliedFilters,
    savedSearchId
  };
};
const isModifiedEvent = event => !!(event.metaKey || event.altKey || event.ctrlKey || event.shiftKey);
const useNavigationProps = ({
  dataView,
  rowIndex,
  rowId,
  columns,
  savedSearchId,
  filters
}) => {
  const isEmbeddableView = !(0, _reactRouterDom.useHistory)();
  const services = (0, _use_discover_services.useDiscoverServices)();
  const [singleDocHref, setSingleDocHref] = (0, _react.useState)('');
  const [contextViewHref, setContextViewHref] = (0, _react.useState)('');
  const index = (0, _react.useMemo)(() => dataView.isPersisted() ? dataView.id : dataView.toSpec(false), [dataView]);
  const buildParams = (0, _react.useCallback)(() => getStateParams({
    isEmbeddableView,
    columns,
    filters,
    filterManager: services.filterManager,
    data: services.data,
    savedSearchId
  }), [columns, filters, isEmbeddableView, savedSearchId, services.data, services.filterManager]);
  (0, _react.useEffect)(() => {
    if (!rowIndex || !rowId) {
      return;
    }
    const dataViewId = typeof index === 'object' ? index.id : index;
    services.locator.getUrl({
      dataViewId,
      ...buildParams()
    }).then(referrer => {
      return services.singleDocLocator.getRedirectUrl({
        index,
        rowIndex,
        rowId,
        referrer
      });
    }).then(setSingleDocHref);
  }, [index, rowIndex, rowId, services.singleDocLocator, setSingleDocHref, services.locator, buildParams]);
  (0, _react.useEffect)(() => {
    if (!rowIndex || !rowId) {
      return;
    }
    const params = buildParams();
    const dataViewId = typeof index === 'object' ? index.id : index;
    services.locator.getUrl({
      dataViewId,
      ...params
    }).then(referrer => {
      var _params$filters;
      return services.contextLocator.getRedirectUrl({
        index,
        rowId,
        columns: params.columns,
        filters: (_params$filters = params.filters) === null || _params$filters === void 0 ? void 0 : _params$filters.map(_esQuery.disableFilter),
        referrer
      });
    }).then(setContextViewHref);
  }, [index, rowIndex, rowId, setContextViewHref, buildParams, services.contextLocator, services.locator]);
  const onOpenSingleDoc = (0, _react.useCallback)(event => {
    if (isModifiedEvent(event) || !rowIndex || !rowId) {
      return;
    }
    event.preventDefault();
    const dataViewId = typeof index === 'object' ? index.id : index;
    services.locator.getUrl({
      dataViewId,
      ...buildParams()
    }).then(referrer => services.singleDocLocator.navigate({
      index,
      rowIndex,
      rowId,
      referrer
    }));
  }, [buildParams, index, rowId, rowIndex, services.locator, services.singleDocLocator]);
  const onOpenContextView = (0, _react.useCallback)(event => {
    if (isModifiedEvent(event) || !rowId) {
      return;
    }
    event.preventDefault();
    const params = buildParams();
    const dataViewId = typeof index === 'object' ? index.id : index;
    services.locator.getUrl({
      dataViewId,
      ...params
    }).then(referrer => {
      var _params$filters2;
      return services.contextLocator.navigate({
        index,
        rowId,
        columns: params.columns,
        filters: (_params$filters2 = params.filters) === null || _params$filters2 === void 0 ? void 0 : _params$filters2.map(_esQuery.disableFilter),
        referrer
      });
    });
  }, [buildParams, index, rowId, services.contextLocator, services.locator]);
  return {
    singleDocHref,
    contextViewHref,
    onOpenSingleDoc,
    onOpenContextView
  };
};
exports.useNavigationProps = useNavigationProps;