"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAwsS3accessLogsDataSourceProfileProvider = void 0;
var _extend_profile_provider = require("../../../extend_profile_provider");
var _accessors = require("../accessors");
var _consts = require("../consts");
var _create_resolve = require("./create_resolve");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createAwsS3accessLogsDataSourceProfileProvider = logsDataSourceProfileProvider => (0, _extend_profile_provider.extendProfileProvider)(logsDataSourceProfileProvider, {
  profileId: 'observability-aws-s3access-logs-data-source-profile',
  profile: {
    getDefaultAppState: (0, _accessors.createGetDefaultAppState)({
      defaultColumns: [{
        name: 'aws.s3.bucket.name',
        width: 200
      }, {
        name: 'aws.s3.object.key',
        width: 200
      }, {
        name: 'aws.s3access.operation',
        width: 200
      }, _consts.CLIENT_IP_COLUMN, _consts.MESSAGE_COLUMN]
    })
  },
  resolve: (0, _create_resolve.createResolve)('logs-aws.s3access')
});
exports.createAwsS3accessLogsDataSourceProfileProvider = createAwsS3accessLogsDataSourceProfileProvider;