"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverHistogramLayout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _unifiedHistogram = require("@kbn/unified-histogram");
var _reactReversePortal = require("react-reverse-portal");
var _discover_main_content = require("./discover_main_content");
var _redux = require("../../state_management/redux");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DiscoverHistogramLayout = ({
  container,
  panelsToggle,
  ...mainContentProps
}) => {
  const chartPortalNode = (0, _redux.useCurrentChartPortalNode)();
  const layoutProps = (0, _redux.useCurrentTabRuntimeState)(mainContentProps.stateContainer.runtimeStateManager, tab => tab.unifiedHistogramLayoutProps$);
  if (!layoutProps) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_unifiedHistogram.UnifiedHistogramLayout, (0, _extends2.default)({
    container: container,
    unifiedHistogramChart: chartPortalNode ? /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
      node: chartPortalNode,
      panelsToggle: panelsToggle
    }) : null
  }, layoutProps), /*#__PURE__*/_react.default.createElement(_discover_main_content.DiscoverMainContent, (0, _extends2.default)({}, mainContentProps, {
    panelsToggle: panelsToggle
  })));
};
exports.DiscoverHistogramLayout = DiscoverHistogramLayout;