/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
"use strict";(self.dataVisualizer_bundle_jsonpfunction=self.dataVisualizer_bundle_jsonpfunction||[]).push([[480],{3086:(e,t,i)=>{i.d(t,{Lx:()=>FileUploadManager,XQ:()=>u});var s=i(8915),a=i(190),n=i(5008),l=i(770),r=i(8312),o=i(1340);class AutoDeploy{constructor(e,t){(0,s.default)(this,"inferError",null),(0,s.default)(this,"inferFinished",!1),this.http=e,this.inferenceId=t}async deploy(){this.inferError=null,await this.isDeployed()||(this.infer().then((()=>{this.inferFinished=!0})).catch((e=>{var t;const i=null===(t=e.response)||void 0===t?void 0:t.status;408!==i&&504!==i&&502!==i&&500!==i&&(this.inferError=e)})),await this.pollIsDeployed())}async infer(){return this.http.fetch(`/internal/data_visualizer/inference/${this.inferenceId}`,{method:"POST",version:"1",body:JSON.stringify({input:""})})}async isDeployed(){const e=await this.http.fetch("/internal/data_visualizer/inference_endpoints",{method:"GET",version:"1"});return!!this.inferFinished||e.some((e=>e.inference_id===this.inferenceId&&e.service_settings.num_allocations>0))}async pollIsDeployed(){for(;;){if(null!==this.inferError)throw this.inferError;if(await this.isDeployed())return;await new Promise((e=>setTimeout(e,5e3)))}}}var d=i(5433);let u=function(e){return e[e.NA=0]="NA",e[e.NOT_STARTED=1]="NOT_STARTED",e[e.STARTED=2]="STARTED",e[e.COMPLETED=3]="COMPLETED",e[e.FAILED=4]="FAILED",e}({});class FileUploadManager{constructor(e,t,i,n,l=null,r=!0,d=!0,p=null,c=void 0){(0,s.default)(this,"files$",new a.BehaviorSubject([])),(0,s.default)(this,"analysisValid$",new a.BehaviorSubject(!1)),(0,s.default)(this,"fileAnalysisStatus$",this.files$.pipe((0,a.switchMap)((e=>e.length>0?(0,a.combineLatest)(e.map((e=>e.fileStatus$))):(0,a.of)([]))))),(0,s.default)(this,"filePipelines$",this.files$.pipe((0,a.switchMap)((e=>e.length>0?(0,a.combineLatest)(e.map((e=>e.pipelineObvs$))):(0,a.of)([]))))),(0,s.default)(this,"existingIndexMappings$",new a.BehaviorSubject(null)),(0,s.default)(this,"mappingsCheckSubscription",void 0),(0,s.default)(this,"_settings$",new a.BehaviorSubject({json:{},valid:!1})),(0,s.default)(this,"settings$",this._settings$.asObservable()),(0,s.default)(this,"_mappings$",new a.BehaviorSubject({json:{},valid:!1})),(0,s.default)(this,"mappings$",this._mappings$.asObservable()),(0,s.default)(this,"_existingIndexName$",new a.BehaviorSubject(null)),(0,s.default)(this,"existingIndexName$",this._existingIndexName$.asObservable()),(0,s.default)(this,"inferenceId",null),(0,s.default)(this,"importer",null),(0,s.default)(this,"timeFieldName",null),(0,s.default)(this,"commonFileFormat",null),(0,s.default)(this,"_uploadStatus$",new a.BehaviorSubject({analysisStatus:u.NOT_STARTED,overallImportStatus:u.NOT_STARTED,indexCreated:u.NOT_STARTED,pipelineCreated:u.NOT_STARTED,modelDeployed:u.NA,dataViewCreated:u.NOT_STARTED,pipelinesDeleted:u.NOT_STARTED,fileImport:u.NOT_STARTED,filesStatus:[],fileClashes:[],formatMix:!1,mappingsJsonValid:!0,settingsJsonValid:!0,pipelinesJsonValid:!0,errors:[]})),(0,s.default)(this,"uploadStatus$",this._uploadStatus$.asObservable()),(0,s.default)(this,"autoAddSemanticTextField",!1),this.fileUpload=e,this.http=t,this.dataViewsContract=i,this.notifications=n,this.autoAddInferenceEndpointName=l,this.autoCreateDataView=r,this.removePipelinesAfterImport=d,this.setExistingIndexName(p),this.autoAddSemanticTextField=null!==this.autoAddInferenceEndpointName,this.updateSettings(null!=c?c:{}),this.mappingsCheckSubscription=(0,a.combineLatest)([this.fileAnalysisStatus$,this.existingIndexMappings$]).subscribe((([e,t])=>{const i=e.every((e=>e.loaded)),s=null===this.getExistingIndexName()||null!==t;if(i&&s){if(this.setStatus({analysisStatus:u.STARTED}),this.analysisValid$.next(!0),this._uploadStatus$.getValue().overallImportStatus===u.STARTED)return;const t=this.getFiles();if(0===t.length)return void this.setStatus({fileClashes:[],analysisStatus:u.NOT_STARTED});const{formatsOk:i,fileClashes:s}=this.getFormatClashes(),{mappingClashes:a,mergedMappings:n,existingIndexChecks:l}=(0,o.gY)(t,this.existingIndexMappings$.getValue());let r=0===a.length;void 0!==l&&(r=r&&0===l.mappingClashes.length);const d=e.every((e=>!1===e.fileTooLarge));r&&i&&(this.updateMappings(n),this.addSemanticTextField()),this.setStatus({fileClashes:!1===i?s:(0,o.KQ)(a,l,e),analysisStatus:r&&i&&d?u.COMPLETED:u.FAILED,pipelinesJsonValid:this.allPipelinesValid()})}}))}destroy(){this.files$.complete(),this.analysisValid$.complete(),this._settings$.complete(),this._mappings$.complete(),this.existingIndexMappings$.complete(),this._uploadStatus$.complete(),this.mappingsCheckSubscription.unsubscribe()}setStatus(e){this._uploadStatus$.next({...this._uploadStatus$.getValue(),...e})}async addFiles(e){this.setStatus({analysisStatus:u.STARTED});const t=Array.from(e).map((e=>this.addFile(e)));await Promise.all(t)}async addFile(e){const t=new r.C(e,this.fileUpload),i=this.getFiles();i.push(t),this.files$.next(i),await t.analyzeFile()}async removeFile(e){const t=this.getFiles(),i=t[e];t.splice(e,1),this.files$.next(t),i&&i.destroy(),0===t.length&&this.setStatus({analysisStatus:u.NOT_STARTED})}async removeClashingFiles(){const e=this._uploadStatus$.getValue().fileClashes,t=[],i=this.getFiles(),s=i.filter(((s,a)=>e[a].clash!==o.KU.ERROR||(t.push(i[a]),!1)));this.files$.next(s),t.forEach((e=>{e.destroy()}))}analyzeFileWithOverrides(e){return async t=>{const i=this.getFiles()[e];if(i){const e=(0,d.bk)(t,{});await i.analyzeFile(e)}}}getUploadStatus(){return this._uploadStatus$.getValue()}getExistingIndexName(){return this._existingIndexName$.getValue()}setExistingIndexName(e){this.setStatus({analysisStatus:u.NOT_STARTED}),this._existingIndexName$.next(e),null===e?this.existingIndexMappings$.next(null):(this.loadExistingIndexMappings(),this.autoCreateDataView=!1)}isExistingIndexUpload(){return null!==this.getExistingIndexName()}getFiles(){return this.files$.getValue()}getFormatClashes(){const e=this.getFiles(),t=(0,o.PH)(e),i=t.every((e=>e.clash===o.KU.NONE));return i&&(this.commonFileFormat=i?e[0].getStatus().results.format:null),{formatsOk:i,fileClashes:t}}getPipelines(){return this.getFiles().map((e=>e.getPipeline()))}allPipelinesValid(){return this.getFiles().every((e=>e.isPipelineValid()))}updatePipeline(e){return t=>{this.getFiles()[e].updatePipeline(t)}}updatePipelines(e){this.getFiles().forEach(((t,i)=>{t.setPipeline(e[i])}))}getMappings(){return this._mappings$.getValue()}updateMappings(e){this.updateSettingsOrMappings("mappings",e)}getSettings(){return this._settings$.getValue()}updateSettings(e){this.updateSettingsOrMappings("settings",e)}updateSettingsOrMappings(e,t){const i="settings"===e?this._settings$:this._mappings$,s="settings"===e?"settingsJsonValid":"mappingsJsonValid",a=i.getValue();if("string"==typeof t)try{const e=JSON.parse(t);if(this.setStatus({[s]:!0}),(0,l.isEqual)(a.json,e))return;i.next({json:e,valid:!0})}catch(e){return void this.setStatus({[s]:!1})}else i.next({json:t,valid:!0})}getAutoCreateDataView(){return this.autoCreateDataView}async import(e,t){var i,s;const a=this.getMappings().json,l=this.getPipelines();if(null===a||null===l||null===this.commonFileFormat)return this.setStatus({overallImportStatus:u.FAILED}),null;this.setStatus({overallImportStatus:u.STARTED,dataViewCreated:this.autoCreateDataView?u.NOT_STARTED:u.NA}),this.importer=await this.fileUpload.importerFactory(this.commonFileFormat,{}),this.inferenceId=function(e){for(const i of Object.values(null!==(t=e.properties)&&void 0!==t?t:{})){var t;if("semantic_text"===i.type&&i.inference_id)return i.inference_id}return null}(a),null!==this.inferenceId&&(this.setStatus({modelDeployed:u.NOT_STARTED}),this.setStatus({modelDeployed:u.STARTED}),await this.autoDeploy(),this.setStatus({modelDeployed:u.COMPLETED}));const r=l.length>0;this.setStatus({indexCreated:u.STARTED,pipelineCreated:r?u.STARTED:u.NA});let o,d=!1,p=!1;try{if(o=await this.importer.initializeImport(e,this.getSettings().json,a,l,this.isExistingIndexUpload()),this.timeFieldName=this.importer.getTimeField(),d=void 0!==o.index,p=o.pipelineIds.length>0,this.setStatus({indexCreated:d?u.COMPLETED:u.FAILED,...r?{pipelineCreated:p?u.COMPLETED:u.FAILED}:{}}),o.error)throw o.error}catch(e){return this.setStatus({overallImportStatus:u.FAILED,errors:[{title:n.i18n.translate("xpack.dataVisualizer.file.fileManager.errorInitializing",{defaultMessage:"Error initializing index and ingest pipeline"}),error:e}]}),null}if(!1===d||r&&!1===p||!o)return null;this.setStatus({fileImport:u.STARTED});const c=this.getFiles(),m=o.pipelineIds;try{await Promise.all(c.map((async(t,i)=>{var s;await t.import(e,a,null!==(s=m[i])&&void 0!==s?s:void 0)})))}catch(e){return this.setStatus({overallImportStatus:u.FAILED,errors:[{title:n.i18n.translate("xpack.dataVisualizer.file.fileManager.errorImportingData",{defaultMessage:"Error importing data"}),error:e}]}),null}if(this.setStatus({fileImport:u.COMPLETED}),this.removePipelinesAfterImport)try{this.setStatus({pipelinesDeleted:u.STARTED}),await this.importer.deletePipelines(),this.setStatus({pipelinesDeleted:u.COMPLETED})}catch(e){this.setStatus({pipelinesDeleted:u.FAILED,errors:[{title:n.i18n.translate("xpack.dataVisualizer.file.fileManager.errorDeletingPipelines",{defaultMessage:"Error deleting pipelines"}),error:e}]})}let h;if(this.autoCreateDataView&&null!==t){var f;this.setStatus({dataViewCreated:u.STARTED});const i=void 0===t?e:t;if(h=await async function(e,t,i){try{return{success:!0,id:(await t.createAndSave({title:e,timeFieldName:i})).id}}catch(e){return{success:!1,error:e,id:void 0,title:void 0}}}(i,this.dataViewsContract,null!==(f=this.timeFieldName)&&void 0!==f?f:void 0),!1===h.success)return this.setStatus({overallImportStatus:u.FAILED,errors:[{title:n.i18n.translate("xpack.dataVisualizer.file.fileManager.errorCreatingDataView",{defaultMessage:"Error creating data view"}),error:h.error}]}),null;this.setStatus({dataViewCreated:u.COMPLETED})}return this.setStatus({overallImportStatus:u.COMPLETED}),{index:e,dataView:h?{id:h.id,title:h.title}:void 0,inferenceId:null!==(i=this.inferenceId)&&void 0!==i?i:void 0,timeFieldName:null!==(s=this.timeFieldName)&&void 0!==s?s:void 0,files:this.getFiles().map((e=>{const t=e.getStatus();return{fileName:t.fileName,docCount:t.docCount,fileFormat:t.results.format,documentType:t.results.document_type}}))}}async autoDeploy(){if(null!==this.inferenceId)try{const e=new AutoDeploy(this.http,this.inferenceId);await e.deploy()}catch(e){this.setStatus({modelDeployed:u.FAILED,errors:[{title:n.i18n.translate("xpack.dataVisualizer.file.fileManager.errorDeployingModel",{defaultMessage:"Error deploying model"}),error:e}]})}}isTikaFormat(){return"tika"===this.commonFileFormat}addSemanticTextField(){const e=this.getMappings().json,t=this.getPipelines();this.isTikaFormat()&&this.autoAddSemanticTextField&&null!==this.autoAddInferenceEndpointName&&null!==t&&null!==e&&(e.properties.content={type:"semantic_text",inference_id:this.autoAddInferenceEndpointName},t.forEach((e=>{void 0!==e&&e.processors.push({set:{field:"content",copy_from:"attachment.content"}})})),this.updateMappings(e),this.updatePipelines(t))}async loadExistingIndexMappings(){const e=this.getExistingIndexName();if(null!==e)try{const{mappings:t}=await this.http.fetch(`/api/index_management/mapping/${e}`,{method:"GET",version:"1"});this.existingIndexMappings$.next(t)}catch(t){this.existingIndexMappings$.next(null),this.notifications.toasts.addError(t,{title:n.i18n.translate("xpack.dataVisualizer.file.fileManager.errorLoadingExistingMappings",{defaultMessage:"Error loading existing index mappings for {indexName}",values:{indexName:e}})})}}}},9569:(e,t,i)=>{i.d(t,{H:()=>FileSizeChecker});var s=i(8915),a=i(6752),n=i.n(a),l=i(8648),r=i(4531);class FileSizeChecker{constructor(e,t){(0,s.default)(this,"_maxBytes",void 0),(0,s.default)(this,"_fileSize",void 0),this._fileSize=t.size,this._maxBytes=(0,r.w)(t.type)?e.getMaxTikaBytes():e.getMaxBytes()}isValid(){return this._fileSize<=this._maxBytes}maxBytes(){return this._maxBytes}fileSizeFormatted(){return n()(this._fileSize).format(l.UQ)}maxFileSizeFormatted(){return n()(this._maxBytes).format(l.UQ)}fileSizeDiffFormatted(){return n()(this._fileSize-this._maxBytes).format(l.UQ)}}},8312:(e,t,i)=>{i.d(t,{C:()=>FileWrapper});var s=i(8915),a=i(190),n=i(4531),l=i(3086),r=i(8648),o=i(9569),d=i(5433);class FileWrapper{constructor(e,t){(0,s.default)(this,"analyzedFile$",new a.BehaviorSubject({analysisStatus:l.XQ.NOT_STARTED,fileContents:"",results:null,explanation:void 0,serverSettings:null,overrides:{},loaded:!1,importStatus:l.XQ.NOT_STARTED,fileName:"",data:null,fileTooLarge:!1,fileCouldNotBeRead:!1,fileCouldNotBeReadPermissionError:!1,serverError:!1,importProgress:0,docCount:0,supportedFormat:!0,failures:[],fileSizeInfo:{fileSize:0,fileSizeFormatted:"",maxFileSizeFormatted:"",diffFormatted:""}})),(0,s.default)(this,"pipeline$",new a.BehaviorSubject(void 0)),(0,s.default)(this,"pipelineObvs$",this.pipeline$.asObservable()),(0,s.default)(this,"pipelineJsonValid$",new a.BehaviorSubject(!0)),(0,s.default)(this,"fileStatus$",this.analyzedFile$.asObservable()),(0,s.default)(this,"fileSizeChecker",void 0),this.file=e,this.fileUpload=t,this.fileSizeChecker=new o.H(t,e),this.analyzedFile$.next({...this.analyzedFile$.getValue(),fileName:this.file.name,loaded:!1,fileTooLarge:!this.fileSizeChecker.isValid(),fileSizeInfo:{fileSize:this.file.size,fileSizeFormatted:this.fileSizeChecker.fileSizeFormatted(),maxFileSizeFormatted:this.fileSizeChecker.maxFileSizeFormatted(),diffFormatted:this.fileSizeChecker.fileSizeDiffFormatted()}})}destroy(){this.analyzedFile$.complete(),this.pipeline$.complete(),this.pipelineJsonValid$.complete()}async analyzeFile(e={}){this.setStatus({analysisStatus:l.XQ.STARTED}),(0,d.TA)(this.file).then((async({data:t,fileContents:i})=>{var s,a,l;let r,o=i;(0,n.w)(this.file.type)?(r=await this.analyzeTika(t),o=r.fileContents):r=await this.analyzeStandardFile(i,e);const u=(0,d.gc)(null!==(s=null===(a=r.results)||void 0===a?void 0:a.format)&&void 0!==s?s:"");this.setStatus({...r,loaded:!0,fileName:this.file.name,fileContents:o,data:t,supportedFormat:u}),this.setPipeline(null===(l=r.results)||void 0===l?void 0:l.ingest_pipeline)}))}async analyzeTika(e,t=!1){const{tikaResults:i,standardResults:s}=await async function(e,t){const i=await t.previewTikaFile(e),s=(i.content.match(/\n/g)||"").length+1;return{tikaResults:i,standardResults:{results:{format:r.GM.TIKA,document_type:i.content_type,charset:"utf-8",has_header_row:!1,has_byte_order_marker:!1,sample_start:"",quote:"",delimiter:"",need_client_timezone:!1,num_lines_analyzed:s,num_messages_analyzed:0,explanation:[],field_stats:{"attachment.content":{},"attachment.content_length":{},"attachment.content_type":{},"attachment.format":{},"attachment.language":{}},mappings:{properties:{attachment:{properties:{content:{type:"text",fields:{keyword:{type:"keyword",ignore_above:256}}},content_length:{type:"long"},content_type:{type:"text",fields:{keyword:{type:"keyword",ignore_above:256}}},format:{type:"text",fields:{keyword:{type:"keyword",ignore_above:256}}},language:{type:"text",fields:{keyword:{type:"keyword",ignore_above:256}}}}}}},ingest_pipeline:{description:"Ingest pipeline created by file data visualizer",processors:[{attachment:{field:"data",remove_binary:!0,indexed_chars:-1}}]}}}}}(e,this.fileUpload),a=(0,d.I9)(s);return{fileContents:i.content,results:s.results,explanation:s.results.explanation,serverSettings:a,overrides:{},analysisStatus:l.XQ.COMPLETED}}async analyzeStandardFile(e,t,i=!1){try{var s;const i=await this.fileUpload.analyzeFile(e,t),a=(0,d.I9)(i);return{fileContents:e,results:i.results,explanation:i.results.explanation,serverSettings:a,overrides:null!==(s=i.overrides)&&void 0!==s?s:{},analysisStatus:l.XQ.COMPLETED}}catch(t){return{fileContents:e,results:null,explanation:void 0,serverSettings:null,analysisError:t,overrides:{},analysisStatus:l.XQ.FAILED}}}setStatus(e){this.analyzedFile$.next({...this.getStatus(),...e})}getStatus(){return this.analyzedFile$.getValue()}getFileName(){return this.analyzedFile$.getValue().fileName}getMappings(){var e;return null===(e=this.analyzedFile$.getValue().results)||void 0===e?void 0:e.mappings}getPipeline(){return this.pipeline$.getValue()}isPipelineValid(){return this.pipelineJsonValid$.getValue()}setPipeline(e){this.pipeline$.next(e)}setPipelineValid(e){this.pipelineJsonValid$.next(e)}updatePipeline(e){if("string"==typeof e)try{const t=JSON.parse(e),i=this.getPipeline(),s=JSON.stringify(i),a=JSON.stringify(t);if(this.setPipelineValid(!0),s===a)return;this.setPipeline(t)}catch(e){return void this.setPipelineValid(!1)}else this.setPipeline(e)}getFormat(){var e;return null===(e=this.analyzedFile$.getValue().results)||void 0===e?void 0:e.format}getData(){return this.analyzedFile$.getValue().data}getFileSizeInfo(){return{fileSizeFormatted:this.fileSizeChecker.fileSizeFormatted(),maxFileSizeFormatted:this.fileSizeChecker.maxFileSizeFormatted(),diffFormatted:this.fileSizeChecker.fileSizeDiffFormatted()}}async import(e,t,i){this.setStatus({importStatus:l.XQ.STARTED});const s=this.analyzedFile$.getValue().results.format,a=await this.fileUpload.importerFactory(s,{excludeLinesPattern:this.analyzedFile$.getValue().results.exclude_lines_pattern,multilineStartPattern:this.analyzedFile$.getValue().results.multiline_start_pattern}),n=this.getPipeline();a.initializeWithoutCreate(e,t,n?[n]:[]);const r=this.getData();if(null!==r){a.read(r);try{var o;const t=await a.import(e,i,(e=>{this.setStatus({importProgress:e})}));return this.setStatus({docCount:t.docCount,failures:null!==(o=t.failures)&&void 0!==o?o:[],importStatus:l.XQ.COMPLETED}),t}catch(e){return void this.setStatus({importStatus:l.XQ.FAILED})}}else this.setStatus({importStatus:l.XQ.FAILED})}}},3136:(e,t,i)=>{i.d(t,{H9:()=>n.H,KU:()=>a.KU,XQ:()=>s.XQ,wm:()=>l.w});var s=i(3086),a=(i(8312),i(1340)),n=i(9569),l=i(4531)},1340:(e,t,i)=>{i.d(t,{Fb:()=>a,KQ:()=>r,KU:()=>n,PH:()=>o,gY:()=>l});var s=i(770);let a=function(e){return e[e.MAPPING=0]="MAPPING",e[e.FORMAT=1]="FORMAT",e[e.UNSUPPORTED=2]="UNSUPPORTED",e[e.EXISTING_INDEX_MAPPING=3]="EXISTING_INDEX_MAPPING",e[e.MANY_NEW_FIELDS=4]="MANY_NEW_FIELDS",e[e.MANY_UNUSED_FIELDS=5]="MANY_UNUSED_FIELDS",e}({}),n=function(e){return e[e.NONE=0]="NONE",e[e.ERROR=1]="ERROR",e[e.WARNING=2]="WARNING",e}({});function l(e,t){const i=null!==t,a=e.map((e=>{var t;return null!==(t=e.getMappings())&&void 0!==t?t:{properties:{}}}));if(a.every((e=>(0,s.isEqual)(e,a[0]))))return{mergedMappings:a[0],mappingClashes:[]};const n=a.map((e=>d(e)));null!==t&&n.splice(0,0,d(t));const l=[],r=n.reduce(((t,i,s)=>(i.forEach((i=>{if(t.has(i.name)){const a=t.get(i.name);a&&a.type!==i.value.type&&("keyword"===a.type&&"text"===i.value.type?t.set(i.name,i.value):"text"===a.type&&"keyword"===i.value.type||l.push({fieldName:i.name,existingType:a.type,clashingType:{fileName:e[s].getFileName(),newType:i.value.type,fileIndex:s}}))}else t.set(i.name,i.value)})),t)),new Map);null!==t&&n.splice(0,1);const o={properties:Object.fromEntries(r)};if(!0===i){const i={existingFields:[],newFieldsPerFile:[],mappingClashes:[],unmappedFieldsPerFile:[],commonFieldsPerFile:[]},s=d(t),a=s.reduce(((e,t)=>(e.set(t.name,t.value),e)),new Map);i.existingFields=s.map((e=>e.name));for(const[t,s]of n.entries()){const n={fileName:e[t].getFileName(),fileIndex:t,fields:[]},l={fileName:e[t].getFileName(),fileIndex:t,fields:[]};for(const r of s){const s=a.get(r.name);if(void 0!==s){l.fields.push(r.name);const a=s.type;a!==r.value.type&&("text"===a&&"keyword"===r.value.type||i.mappingClashes.push({fieldName:r.name,existingType:a,clashingType:{fileName:e[t].getFileName(),newType:r.value.type,fileIndex:t}}))}else n.fields.push(r.name)}i.newFieldsPerFile.push(n),i.commonFieldsPerFile.push(l),i.unmappedFieldsPerFile.push({fileName:e[t].getFileName(),fileIndex:t,fields:i.existingFields.filter((e=>!l.fields.includes(e)))})}return{mergedMappings:o,mappingClashes:l,existingIndexChecks:i}}return{mergedMappings:o,mappingClashes:l}}function r(e,t,i){var s;const l=i.map(((t,i)=>{const s={index:i,count:0};return e.forEach((e=>{e.clashingType.fileIndex===i&&s.count++})),s})).sort(((e,t)=>t.count-e.count)),r=l[Math.floor(l.length/2)].count>0,o=l.filter((e=>0===e.count)).length,d=o===l.length-o;l.sort(((e,t)=>e.index-t.index));const u=(null!==(s=null==t?void 0:t.mappingClashes)&&void 0!==s?s:[]).reduce(((e,t)=>(e.set(t.clashingType.fileIndex,!0),e)),new Map);return l.map(((e,s)=>{const l=i[e.index].fileName;let o;if(o=u.has(e.index)?{fileName:l,clash:n.ERROR,clashType:a.EXISTING_INDEX_MAPPING}:{fileName:l,clash:d||!1===r&&e.count>0||r&&0===e.count?n.ERROR:n.NONE,clashType:a.MAPPING},null!=t&&t.newFieldsPerFile){const e=t.newFieldsPerFile[s];e&&(o.newFields=e.fields)}if(null!=t&&t.unmappedFieldsPerFile){const e=t.unmappedFieldsPerFile;o.missingFields=e[s].fields}if(null!=t&&t.commonFieldsPerFile){const e=t.commonFieldsPerFile[s];e&&(o.commonFields=e.fields)}return o.clash!==n.ERROR&&o.missingFields&&null!=t&&t.existingFields&&(null==t?void 0:t.existingFields.length)>0&&o.missingFields.length>(t.existingFields.length-1)/2&&(o.clash=n.WARNING),o}))}function o(e){const t=e.map((e=>e.getFormat())).reduce(((e,t,i)=>{var s,a;return void 0===t?e.set("unknown",(null!==(s=e.get("unknown"))&&void 0!==s?s:0)+1):e.set(t,(null!==(a=e.get(t))&&void 0!==a?a:0)+1),e}),new Map);if(1===t.size&&!1===t.has("unknown"))return e.map((e=>({fileName:e.getFileName(),clash:n.NONE})));const i=Array.from(t.entries()).sort(((e,t)=>t[1]-e[1])),s=e.map((e=>({fileName:e.getFileName(),clash:!1===e.getStatus().supportedFormat?n.ERROR:n.NONE,clashType:a.UNSUPPORTED}))),l=i[0];if("unknown"===l[0])return s;const r=Array.from(t.values());return r.every((e=>e===r[0]))?e.map((e=>({fileName:e.getFileName(),clash:n.ERROR,clashType:e.getStatus().supportedFormat?a.FORMAT:a.UNSUPPORTED}))):e.map((e=>{let t;return!1===e.getStatus().supportedFormat?t=a.UNSUPPORTED:e.getFormat()!==l[0]&&(t=a.FORMAT),{fileName:e.getFileName(),clash:void 0!==t?n.ERROR:n.NONE,clashType:t}}))}function d(e){const t=[];return e.properties&&function e(i,s=""){for(const[a,n]of Object.entries(i)){const i=s?`${s}.${a}`:a;n.properties?e(n.properties,i):n.type&&t.push({name:i,value:n})}}(e.properties),t.sort(((e,t)=>e.name.localeCompare(t.name)))}},4531:(e,t,i)=>{i.d(t,{W:()=>n,w:()=>a});var s=i(5008);function a(e){return n(e).isTikaType}const n=e=>{switch(e){case"application/doc":case"application/ms-doc":case"application/msword":case"application/vnd.openxmlformats-officedocument.wordprocessingml.document":return{isTikaType:!0,label:s.i18n.translate("xpack.dataVisualizer.file.tikaTypes.word",{defaultMessage:"Microsoft Office Word document"})};case"application/excel":case"application/vnd.ms-excel":case"application/x-excel":case"application/x-msexcel":case"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet":return{isTikaType:!0,label:s.i18n.translate("xpack.dataVisualizer.file.tikaTypes.excel",{defaultMessage:"Microsoft Office Excel document"})};case"application/mspowerpoint":case"application/powerpoint":case"application/vnd.ms-powerpoint":case"application/x-mspowerpoint":case"application/vnd.openxmlformats-officedocument.presentationml.presentation":return{isTikaType:!0,label:s.i18n.translate("xpack.dataVisualizer.file.tikaTypes.powerPoint",{defaultMessage:"Microsoft Office Power Point document"})};case"application/vnd.oasis.opendocument.presentation":case"application/vnd.oasis.opendocument.spreadsheet":case"application/vnd.oasis.opendocument.text":return{isTikaType:!0,label:s.i18n.translate("xpack.dataVisualizer.file.tikaTypes.openDoc",{defaultMessage:"Open Document Format"})};case"text/rtf":case"application/rtf":return{isTikaType:!0,label:s.i18n.translate("xpack.dataVisualizer.file.tikaTypes.richText",{defaultMessage:"Rich Text Format"})};case"application/pdf":return{isTikaType:!0,label:s.i18n.translate("xpack.dataVisualizer.file.tikaTypes.pdf",{defaultMessage:"PDF"})};case"text/plain":case"text/plain; charset=UTF-8":return{isTikaType:!0,label:s.i18n.translate("xpack.dataVisualizer.file.tikaTypes.plainText",{defaultMessage:"Plain text"})};default:return{isTikaType:!1,label:e}}}},5433:(e,t,i)=>{i.d(t,{I9:()=>u,TA:()=>o,bk:()=>d,gc:()=>p});var s=i(770),a=i(8648);const n=1e3,l=5,r={timestampFormat:void 0,timestampField:void 0,format:void 0,delimiter:void 0,quote:void 0,hasHeaderRow:void 0,charset:void 0,columnNames:void 0,shouldTrimFields:void 0,grokPattern:void 0,linesToSample:void 0};function o(e){return new Promise(((t,i)=>{if(e&&e.size){const s=new FileReader;s.readAsArrayBuffer(e),s.onload=()=>{const e=new TextDecoder,n=s.result;if(null===n||"string"==typeof n)return i();const r=l*a.MB,o=e.decode(n.slice(0,r));""===o?i():t({fileContents:o,data:n})}}else i()}))}function d(e,t){const i={};for(const a in r)if(Object.hasOwn(r,a)){let n=e[a];(Array.isArray(n)&&(0,s.isEqual)(n,t[a])||void 0===n||n===t[a])&&(n=""),i[a.replace(/([A-Z])/g,(e=>`_${e.toLowerCase()}`))]=n}return""===i.format&&t.format===a.GM.DELIMITED&&(""===i.should_trim_fields&&""===i.has_header_row&&""===i.delimiter&&""===i.quote&&""===i.column_names||(i.format=t.format)),i.format===a.GM.DELIMITED&&Array.isArray(i.column_names)&&(i.column_names=i.column_names.join()),""===i.format&&t.format===a.GM.SEMI_STRUCTURED_TEXT&&""!==i.grok_pattern&&(i.format=t.format),i.format!==a.GM.NDJSON&&t.format!==a.GM.NDJSON||(i.should_trim_fields="",i.has_header_row="",i.delimiter="",i.quote="",i.column_names=""),""===i.lines_to_sample&&(i.lines_to_sample=e.linesToSample),i}function u({results:e,overrides:t}){let i;t&&t.timestamp_format===a.cR||void 0===e.java_timestamp_formats?i=a.cR:e.java_timestamp_formats.length&&(i=e.java_timestamp_formats[0]);const s=void 0!==t&&void 0!==t.lines_to_sample?t.lines_to_sample:n;return{format:e.format,delimiter:e.delimiter,timestampField:e.timestamp_field,timestampFormat:i,quote:e.quote,hasHeaderRow:e.has_header_row,shouldTrimFields:e.should_trim_fields,charset:e.charset,columnNames:e.column_names,grokPattern:e.grok_pattern,linesToSample:s}}function p(e){return e===a.GM.NDJSON||e===a.GM.DELIMITED||e===a.GM.SEMI_STRUCTURED_TEXT||e===a.GM.TIKA}},3955:(e,t,i)=>{i.d(t,{B:()=>r,V:()=>l});var s=i(770),a=i(3304),n=i(2787);function l(e){const{mappings:t,field_stats:i,column_names:a}=e,n=void 0!==a?a:Object.keys(i),l=(0,s.difference)(Object.keys(t.properties),n),r=l.indexOf("@timestamp");return-1!==r&&l.splice(r,1),l.length&&n.push(...l),n}function r(e){switch(e){case a._c.FLOAT:case a._c.HALF_FLOAT:case a._c.SCALED_FLOAT:case a._c.DOUBLE:case a._c.INTEGER:case a._c.LONG:case a._c.SHORT:case a._c.UNSIGNED_LONG:return n.kH.NUMBER;case a._c.DATE:case a._c.DATE_NANOS:return n.kH.DATE;default:return e}}},518:(e,t,i)=>{i.d(t,{X:()=>u});var s=i(5879),a=i(4286),n=i.n(a),l=i(1319),r=i(8648),o=i(4531),d=i(6791);const u=({results:e,showTitle:t=!0})=>{const i=function(e){const t=[{title:(0,d.jsx)(s.FormattedMessage,{id:"xpack.dataVisualizer.file.analysisSummary.analyzedLinesNumberTitle",defaultMessage:"Number of lines analyzed"}),description:e.num_lines_analyzed}];return void 0!==e.format&&(t.push({title:(0,d.jsx)(s.FormattedMessage,{id:"xpack.dataVisualizer.file.analysisSummary.formatTitle",defaultMessage:"Format"}),description:p(e)}),e.format===r.GM.DELIMITED&&(t.push({title:(0,d.jsx)(s.FormattedMessage,{id:"xpack.dataVisualizer.file.analysisSummary.delimiterTitle",defaultMessage:"Delimiter"}),description:e.delimiter}),t.push({title:(0,d.jsx)(s.FormattedMessage,{id:"xpack.dataVisualizer.file.analysisSummary.hasHeaderRowTitle",defaultMessage:"Has header row"}),description:`${e.has_header_row}`}))),void 0!==e.grok_pattern&&t.push({title:(0,d.jsx)(s.FormattedMessage,{id:"xpack.dataVisualizer.file.analysisSummary.grokPatternTitle",defaultMessage:"Grok pattern"}),description:e.grok_pattern}),void 0!==e.timestamp_field&&t.push({title:(0,d.jsx)(s.FormattedMessage,{id:"xpack.dataVisualizer.file.analysisSummary.timeFieldTitle",defaultMessage:"Time field"}),description:e.timestamp_field}),void 0!==e.java_timestamp_formats&&t.push({title:(0,d.jsx)(s.FormattedMessage,{id:"xpack.dataVisualizer.file.analysisSummary.timeFormatTitle",defaultMessage:"Time {timestampFormats, plural, zero {format} one {format} other {formats}}",values:{timestampFormats:e.java_timestamp_formats.length}}),description:e.java_timestamp_formats.join(", ")}),t}(e);return(0,d.jsx)(n().Fragment,null,t?(0,d.jsx)(l.EuiTitle,{size:"s"},(0,d.jsx)("h2",null,(0,d.jsx)(s.FormattedMessage,{id:"xpack.dataVisualizer.file.analysisSummary.summaryTitle",defaultMessage:"Summary"}))):null,(0,d.jsx)(l.EuiSpacer,{size:"m"}),(0,d.jsx)(l.EuiDescriptionList,{type:"column",columnWidths:t?[15,85]:[50,50],listItems:i,className:"analysis-summary-list",compressed:!0}))};function p(e){return e.format===r.GM.TIKA&&void 0!==e.document_type?(0,o.W)(e.document_type).label:e.format}},5556:(e,t,i)=>{i.d(t,{Z:()=>x});var s=i(4286),a=i.n(s),n=i(5879),l=i(1319),r=i(7157),o=i.n(r),d=i(5008),u=i(8648),p=i(367),c=i(6791),m=i(1936),h=i(3955);const f=({type:e,value:t,name:i})=>{const{euiTheme:s}=(0,l.useEuiTheme)(),a=s.colors.lightestShade,n=s.colors.lightShade,r=(0,h.B)(null!=e?e:"unknown"),o=e?d.i18n.translate("xpack.dataVisualizer.file.fileContents.fieldBadge.tooltip",{defaultMessage:"Type: {type}",values:{type:r}}):void 0;return(0,c.jsx)(l.EuiToolTip,{title:i,content:o},(0,c.jsx)(l.EuiBadge,{"data-test-subj":"dataVisualizerFieldBadge",tabIndex:0,css:(0,c.css)({marginRight:"2px",marginTop:"-4px",padding:"0px 4px",cursor:"pointer",pointerEvents:"none",border:`1px solid ${n}`,backgroundColor:a},"","")},(0,c.jsx)(l.EuiFlexGroup,{gutterSize:"none"},(0,c.jsx)(l.EuiFlexItem,{grow:!1},(0,c.jsx)(m.q,{type:r,css:(0,c.css)({marginRight:"4px",marginTop:"1px",border:`1px solid ${n}`},"","")})),(0,c.jsx)(l.EuiFlexItem,null,t))))};var g=i(2291),y=i(4685);class GrokHighlighter extends y.MessageImporter{constructor(e,t){super(e),this.http=t}async createLines(e,t,i,s){const a=this._createDocs(e,!1,5).docs.map((e=>e.message)),n=await this.testGrokPattern(a,t,s);return a.map(((e,t)=>{const{matched:s,fields:a}=n[t];if(!1===s)return[{word:e}];const l=Object.entries(a).map((([e,[{match:t,offset:s,length:a}]])=>{var n;let l=null===(n=i.properties[e])||void 0===n?void 0:n.type;var r;return void 0===l&&"timestamp"===e&&(l=null===(r=i.properties["@timestamp"])||void 0===r?void 0:r.type),{name:e,match:t,offset:s,length:a,type:l}})).sort(((e,t)=>e.offset-t.offset));let r=0;const o=[];for(const t of l)o.push({word:e.substring(r,t.offset)}),o.push({word:t.match,field:{type:t.type,name:t.name}}),r=t.offset+t.length;return o.push({word:e.substring(r)}),o}))}async testGrokPattern(e,t,i){const{matches:s}=await this.http.fetch("/internal/data_visualizer/test_grok_pattern",{method:"POST",version:"1",body:JSON.stringify({grokPattern:t,text:e,ecsCompatibility:i})});return s}}const x=({fileContents:e,results:t,showTitle:i=!0,disableHighlighting:r=!1})=>{let m=p.E.TEXT;const h=t.format,y=t.num_lines_analyzed;h===p.E.JSON&&(m=p.E.JSON);const x=o()(),T=function(){const{services:{http:e}}=(0,g.Y)(),{euiTheme:t}=(0,l.useEuiTheme)();return(0,s.useMemo)((()=>async(i,s,a,n,r,o)=>{const d=new GrokHighlighter({multilineStartPattern:r,excludeLinesPattern:o},e);return(await d.createLines(i,s,a,n)).map((e=>{const i=[];for(let t=0;t<e.length;t++){const{word:s,field:a}=e[t],n=`word-${t}`;a?i.push((0,c.jsx)(f,{type:a.type,value:s,name:a.name,key:n})):i.push((0,c.jsx)("span",{key:n},s))}return(0,c.jsx)(l.EuiText,{size:"s",css:(0,c.css)({lineHeight:t.size.l},"",""),"data-test-subj":"dataVisualizerHighlightedLine"},(0,c.jsx)("code",null,i))}))}),[t,e])}(),F=(0,s.useMemo)((()=>t.format===u.GM.SEMI_STRUCTURED_TEXT?{grokPattern:t.grok_pattern,multilineStartPattern:t.multiline_start_pattern,sampleStart:t.sample_start,excludeLinesPattern:t.exclude_lines_pattern,mappings:t.mappings,ecsCompatibility:t.ecs_compatibility}:null),[t]),[v,E]=(0,s.useState)(!1===r&&function(e){return null!==e&&void 0!==e.grokPattern&&void 0!==e.multilineStartPattern}(F)),_=(0,s.useMemo)((()=>function(e,t){return e.split("\n").slice(0,t).join("\n")}(e,y)),[e,y]),[N,w]=(0,s.useState)(null),[M,I]=(0,s.useState)(v);return(0,s.useEffect)((()=>{if(!1===v)return;const{grokPattern:t,multilineStartPattern:i,excludeLinesPattern:s,mappings:a,ecsCompatibility:n}=F;T(e,t,a,n,i,s).then((e=>{x()&&w(e)})).catch((e=>{x()&&(w(null),E(!1))}))}),[e,F,T,v,x]),(0,c.jsx)(a().Fragment,null,(0,c.jsx)(l.EuiFlexGroup,null,(0,c.jsx)(l.EuiFlexItem,null,i?(0,c.jsx)(l.EuiTitle,{size:"s"},(0,c.jsx)("h2",null,(0,c.jsx)(n.FormattedMessage,{id:"xpack.dataVisualizer.file.fileContents.fileContentsTitle",defaultMessage:"File contents"}))):null),v?(0,c.jsx)(l.EuiFlexItem,{grow:!1,"data-test-subj":"dataVisualizerFileContentsHighlightingSwitch"},(0,c.jsx)(l.EuiSwitch,{label:d.i18n.translate("xpack.dataVisualizer.file.fileContents.highlightSwitch",{defaultMessage:"Grok pattern highlighting"}),compressed:!0,checked:M,onChange:()=>I(!M)})):null),(0,c.jsx)(S,{wrapInCallout:!1===i},h===u.GM.TIKA?(0,c.jsx)(n.FormattedMessage,{id:"xpack.dataVisualizer.file.fileContents.characterCount",defaultMessage:"Preview limited to the first {numberOfChars} characters",values:{numberOfChars:u.xr}}):(0,c.jsx)(n.FormattedMessage,{id:"xpack.dataVisualizer.file.fileContents.firstLinesDescription",defaultMessage:"First {numberOfLines, plural, zero {# line} one {# line} other {# lines}}",values:{numberOfLines:M?5:y}})),(0,c.jsx)(l.EuiSpacer,{size:"s"}),null===N||!1===M?(0,c.jsx)(p.i,{mode:m,readOnly:!0,value:_,height:"200px"}):(0,c.jsx)(a().Fragment,null,N.map(((e,t)=>(0,c.jsx)(a().Fragment,{key:`line-${t}`},e,t===N.length-1?null:(0,c.jsx)(l.EuiHorizontalRule,{margin:"s"}))))))},S=({wrapInCallout:e=!1,children:t})=>e?(0,c.jsx)(l.EuiCallOut,{size:"s",color:"primary",title:t}):(0,c.jsx)(a().Fragment,null,(0,c.jsx)(l.EuiSpacer,{size:"s"}),t)},367:(e,t,i)=>{i.d(t,{E:()=>n,i:()=>l}),i(4286);var s=i(9424),a=i(6791);const n={TEXT:"text",JSON:"json"},l=({value:e,height:t="500px",width:i="99%",mode:l=n.JSON,readOnly:r=!1,onChange:o=()=>{}})=>(0,a.jsx)(s.CodeEditor,{value:e,width:i,height:t,languageId:l,languageConfiguration:{autoClosingPairs:[{open:"{",close:"}"}]},options:{tabSize:2,readOnly:r,automaticLayout:!0,wordWrap:"on",wrappingIndent:"indent",minimap:{enabled:!1},scrollBeyondLastLine:!1,quickSuggestions:!0},onChange:o})}}]);