"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppearanceForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("../../../../i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  ContainerStyle: strings
} = _i18n.ArgTypesStrings;
const overflows = [{
  value: 'hidden',
  text: strings.getOverflowHiddenOption()
}, {
  value: 'visible',
  text: strings.getOverflowVisibleOption()
}];
const opacities = [{
  value: 1,
  text: '100%'
}, {
  value: 0.9,
  text: '90%'
}, {
  value: 0.7,
  text: '70%'
}, {
  value: 0.5,
  text: '50%'
}, {
  value: 0.3,
  text: '30%'
}, {
  value: 0.1,
  text: '10%'
}];
const AppearanceForm = ({
  padding = '',
  opacity = 1,
  overflow = 'hidden',
  onChange
}) => {
  if (typeof padding === 'string') {
    padding = padding.replace('px', '');
  }
  const namedChange = name => ev => {
    if (name === 'padding') {
      return onChange(name, `${ev.target.value}px`);
    }
    onChange(name, ev.target.value);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    "justify-content": "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getPaddingLabel(),
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    compressed: true,
    value: Number(padding),
    onChange: namedChange('padding')
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getOpacityLabel(),
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    compressed: true,
    value: opacity,
    options: opacities,
    onChange: namedChange('opacity')
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getOverflowLabel(),
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    compressed: true,
    value: overflow,
    options: overflows,
    onChange: namedChange('overflow')
  }))));
};
exports.AppearanceForm = AppearanceForm;
AppearanceForm.propTypes = {
  padding: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  opacity: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  overflow: _propTypes.default.oneOf(['hidden', 'visible']),
  onChange: _propTypes.default.func.isRequired
};
AppearanceForm.defaultProps = {
  opacity: 1,
  overflow: 'hidden'
};