"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateIntegrationCardButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _integrations_light = _interopRequireDefault(require("../../common/images/integrations_light.svg"));
var _use_kibana = require("../../common/hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = compressed => {
  const paddings = (0, _eui.useEuiPaddingCSS)();
  return {
    image: (0, _react2.css)`
      width: ${compressed ? '140px' : '160px'};
      height: ${compressed ? '90px' : '155px'};
      object-fit: cover;
      object-position: left center;
    `,
    container: (0, _react2.css)`
      height: ${compressed ? '80px' : '135px'};
    `,
    textContainer: (0, _react2.css)`
      height: 100%;
      ${compressed ? `${paddings.m.styles}` : `${paddings.l.styles} padding-right: 0;`}
    `
  };
};
const CreateIntegrationCardButton = exports.CreateIntegrationCardButton = /*#__PURE__*/_react.default.memo(({
  compressed = false
}) => {
  const {
    getUrlForApp,
    navigateToUrl
  } = (0, _use_kibana.useKibana)().services.application;
  const styles = useStyles(compressed);
  const href = (0, _react.useMemo)(() => getUrlForApp('integrations', {
    path: '/create'
  }), [getUrlForApp]);
  const navigate = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateToUrl(href);
  }, [href, navigateToUrl]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "none",
    css: styles.container,
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    justifyContent: "spaceBetween",
    css: styles.textContainer
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.automaticImport.createIntegrationTitle",
    defaultMessage: "Can't find an Integration?"
  }))), !compressed && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.automaticImport.createIntegrationDescription",
    defaultMessage: "Create a custom one to fit your requirements"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    color: "primary",
    href: href,
    onClick: navigate,
    "data-test-subj": "createIntegrationLink"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center",
    gutterSize: compressed ? 'xs' : 's',
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "plusInCircle",
    size: compressed ? 's' : 'm'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.automaticImport.createIntegrationButton",
    defaultMessage: "Create new integration"
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    alt: "create integration background",
    src: _integrations_light.default,
    css: styles.image
  }))));
});
CreateIntegrationCardButton.displayName = 'CreateIntegrationCardButton';