"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.errorsRouteRepository = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var t = _interopRequireWildcard(require("io-ts"));
var _boom = require("@hapi/boom");
var _create_apm_server_route = require("../apm_routes/create_apm_server_route");
var _get_distribution = require("./distribution/get_distribution");
var _default_api_types = require("../default_api_types");
var _get_error_group_main_statistics = require("./get_error_groups/get_error_group_main_statistics");
var _get_error_group_detailed_statistics = require("./get_error_groups/get_error_group_detailed_statistics");
var _get_error_group_sample_ids = require("./get_error_groups/get_error_group_sample_ids");
var _get_error_sample_details = require("./get_error_groups/get_error_sample_details");
var _comparison_rt = require("../../../common/comparison_rt");
var _get_top_erroneous_transactions = require("./erroneous_transactions/get_top_erroneous_transactions");
var _get_apm_event_client = require("../../lib/helpers/get_apm_event_client");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const errorsMainStatisticsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/errors/groups/main_statistics',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([t.partial({
      sortField: t.string,
      sortDirection: t.union([t.literal('asc'), t.literal('desc')]),
      searchQuery: t.string
    }), _default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const {
      params
    } = resources;
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      serviceName
    } = params.path;
    const {
      environment,
      kuery,
      sortField,
      sortDirection,
      start,
      end,
      searchQuery
    } = params.query;
    return await (0, _get_error_group_main_statistics.getErrorGroupMainStatistics)({
      environment,
      kuery,
      serviceName,
      sortField,
      sortDirection,
      apmEventClient,
      start,
      end,
      searchQuery
    });
  }
});
const errorsMainStatisticsByTransactionNameRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/errors/groups/main_statistics_by_transaction_name',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([t.type({
      transactionType: t.string,
      transactionName: t.string,
      maxNumberOfErrorGroups: _ioTsUtils.toNumberRt
    }), _default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const {
      params
    } = resources;
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      serviceName
    } = params.path;
    const {
      environment,
      kuery,
      start,
      end,
      transactionName,
      transactionType,
      maxNumberOfErrorGroups
    } = params.query;
    return await (0, _get_error_group_main_statistics.getErrorGroupMainStatistics)({
      environment,
      kuery,
      serviceName,
      apmEventClient,
      start,
      end,
      maxNumberOfErrorGroups,
      transactionName,
      transactionType
    });
  }
});
const errorsDetailedStatisticsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'POST /internal/apm/services/{serviceName}/errors/groups/detailed_statistics',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt, _comparison_rt.offsetRt, t.type({
      numBuckets: _ioTsUtils.toNumberRt
    })]),
    body: t.type({
      groupIds: _ioTsUtils.jsonRt.pipe(t.array(t.string))
    })
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      path: {
        serviceName
      },
      query: {
        environment,
        kuery,
        numBuckets,
        start,
        end,
        offset
      },
      body: {
        groupIds
      }
    } = params;
    return (0, _get_error_group_detailed_statistics.getErrorGroupPeriods)({
      environment,
      kuery,
      serviceName,
      apmEventClient,
      numBuckets,
      groupIds,
      start,
      end,
      offset
    });
  }
});
const errorGroupsSamplesRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/errors/{groupId}/samples',
  params: t.type({
    path: t.type({
      serviceName: t.string,
      groupId: t.string
    }),
    query: t.intersection([_default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const {
      params
    } = resources;
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      serviceName,
      groupId
    } = params.path;
    const {
      environment,
      kuery,
      start,
      end
    } = params.query;
    return (0, _get_error_group_sample_ids.getErrorGroupSampleIds)({
      environment,
      groupId,
      kuery,
      serviceName,
      apmEventClient,
      start,
      end
    });
  }
});
const errorGroupSampleDetailsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/errors/{groupId}/error/{errorId}',
  params: t.type({
    path: t.type({
      serviceName: t.string,
      groupId: t.string,
      errorId: t.string
    }),
    query: t.intersection([_default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const {
      params
    } = resources;
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      serviceName,
      errorId
    } = params.path;
    const {
      environment,
      kuery,
      start,
      end
    } = params.query;
    const {
      transaction,
      error
    } = await (0, _get_error_sample_details.getErrorSampleDetails)({
      environment,
      errorId,
      kuery,
      serviceName,
      apmEventClient,
      start,
      end
    });
    if (!error) {
      throw (0, _boom.notFound)();
    }
    return {
      error,
      transaction
    };
  }
});
const errorDistributionRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/errors/distribution',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([t.partial({
      groupId: t.string
    }), _default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt, _comparison_rt.offsetRt])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      environment,
      kuery,
      groupId,
      start,
      end,
      offset
    } = params.query;
    return (0, _get_distribution.getErrorDistribution)({
      environment,
      kuery,
      serviceName,
      groupId,
      apmEventClient,
      start,
      end,
      offset
    });
  }
});
const topErroneousTransactionsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/errors/{groupId}/top_erroneous_transactions',
  params: t.type({
    path: t.type({
      serviceName: t.string,
      groupId: t.string
    }),
    query: t.intersection([_default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt, _comparison_rt.offsetRt, t.type({
      numBuckets: _ioTsUtils.toNumberRt
    })])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const {
      params
    } = resources;
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      path: {
        serviceName,
        groupId
      },
      query: {
        environment,
        kuery,
        numBuckets,
        start,
        end,
        offset
      }
    } = params;
    return (0, _get_top_erroneous_transactions.getTopErroneousTransactionsPeriods)({
      environment,
      groupId,
      kuery,
      serviceName,
      apmEventClient,
      start,
      end,
      numBuckets,
      offset
    });
  }
});
const errorsRouteRepository = exports.errorsRouteRepository = {
  ...errorsMainStatisticsRoute,
  ...errorsMainStatisticsByTransactionNameRoute,
  ...errorsDetailedStatisticsRoute,
  ...errorGroupsSamplesRoute,
  ...errorGroupSampleDetailsRoute,
  ...errorDistributionRoute,
  ...topErroneousTransactionsRoute
};