"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapToSingleOrMultiValue = mapToSingleOrMultiValue;
exports.unflattenKnownApmEventFields = unflattenKnownApmEventFields;
var APM_EVENT_FIELDS_MAP = _interopRequireWildcard(require("@kbn/apm-types/es_fields"));
var _unflatten_object = require("@kbn/observability-utils-common/object/unflatten_object");
var _merge_plain_objects = require("@kbn/observability-utils-common/object/merge_plain_objects");
var _lodash = require("lodash");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  CLOUD,
  AGENT,
  SERVICE,
  ERROR_EXCEPTION,
  SPAN_LINKS,
  HOST,
  KUBERNETES,
  CONTAINER,
  TIER,
  INDEX,
  DATA_STEAM_TYPE,
  VALUE_OTEL_JVM_PROCESS_MEMORY_HEAP,
  VALUE_OTEL_JVM_PROCESS_MEMORY_NON_HEAP,
  SPAN_STACKTRACE,
  ...CONCRETE_FIELDS
} = APM_EVENT_FIELDS_MAP;
const ALL_FIELDS = Object.values(CONCRETE_FIELDS);
const KNOWN_MULTI_VALUED_FIELDS = [APM_EVENT_FIELDS_MAP.CHILD_ID, APM_EVENT_FIELDS_MAP.PROCESS_ARGS, APM_EVENT_FIELDS_MAP.OTEL_SPAN_LINKS_TRACE_ID, APM_EVENT_FIELDS_MAP.OTEL_SPAN_LINKS_SPAN_ID];
const KNOWN_SINGLE_VALUED_FIELDS = ALL_FIELDS.filter(field => !KNOWN_MULTI_VALUED_FIELDS.includes(field));
function unflattenKnownApmEventFields(hitFields, requiredFields) {
  var _requiredFields$filte;
  if (!hitFields) {
    return undefined;
  }
  const missingRequiredFields = (_requiredFields$filte = requiredFields === null || requiredFields === void 0 ? void 0 : requiredFields.filter(key => {
    const value = hitFields === null || hitFields === void 0 ? void 0 : hitFields[key];
    return value === null || value === undefined || (0, _lodash.isArray)(value) && value.length === 0;
  })) !== null && _requiredFields$filte !== void 0 ? _requiredFields$filte : [];
  if (missingRequiredFields.length > 0) {
    throw new Error(`Missing required fields ${missingRequiredFields.join(', ')} in event`);
  }
  const copy = mapToSingleOrMultiValue({
    ...hitFields
  });
  const [knownFields, unknownFields] = Object.entries(copy).reduce((prev, [key, value]) => {
    if (ALL_FIELDS.includes(key)) {
      prev[0][key] = value;
    } else {
      prev[1][key] = value;
    }
    return prev;
  }, [{}, {}]);
  const unflattened = (0, _merge_plain_objects.mergePlainObjects)({}, (0, _unflatten_object.unflattenObject)(unknownFields), (0, _unflatten_object.unflattenObject)(knownFields));
  return unflattened;
}
function mapToSingleOrMultiValue(fields) {
  KNOWN_SINGLE_VALUED_FIELDS.forEach(field => {
    const value = fields[field];
    if (value !== null && value !== undefined) {
      fields[field] = (0, _lodash.castArray)(value)[0];
    }
  });
  return fields;
}