"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBreadcrumbs = void 0;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _kibana_react = require("../utils/kibana_react");
var _use_navigation = require("./use_navigation");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const breadcrumbTitle = {
  [_common.MAINTENANCE_WINDOW_DEEP_LINK_IDS.maintenanceWindows]: _i18n.i18n.translate('xpack.alerting.breadcrumbs.maintenanceWindowsLinkText', {
    defaultMessage: 'Maintenance Windows'
  }),
  [_common.MAINTENANCE_WINDOW_DEEP_LINK_IDS.maintenanceWindowsCreate]: _i18n.i18n.translate('xpack.alerting.breadcrumbs.createMaintenanceWindowsLinkText', {
    defaultMessage: 'Create'
  }),
  [_common.MAINTENANCE_WINDOW_DEEP_LINK_IDS.maintenanceWindowsEdit]: _i18n.i18n.translate('xpack.alerting.breadcrumbs.editMaintenanceWindowsLinkText', {
    defaultMessage: 'Edit'
  })
};
const topLevelBreadcrumb = {
  [_common.MAINTENANCE_WINDOW_DEEP_LINK_IDS.maintenanceWindowsCreate]: _common.MAINTENANCE_WINDOW_DEEP_LINK_IDS.maintenanceWindows,
  [_common.MAINTENANCE_WINDOW_DEEP_LINK_IDS.maintenanceWindowsEdit]: _common.MAINTENANCE_WINDOW_DEEP_LINK_IDS.maintenanceWindows
};
function addClickHandlers(breadcrumbs, navigateToHref) {
  return breadcrumbs.map(bc => ({
    ...bc,
    ...(bc.href ? {
      onClick: event => {
        if (navigateToHref && bc.href) {
          event.preventDefault();
          navigateToHref(bc.href);
        }
      }
    } : {})
  }));
}
function getTitleFromBreadCrumbs(breadcrumbs) {
  return breadcrumbs.map(({
    text
  }) => {
    var _text$toString;
    return (_text$toString = text === null || text === void 0 ? void 0 : text.toString()) !== null && _text$toString !== void 0 ? _text$toString : '';
  }).reverse();
}
const useBreadcrumbs = pageDeepLink => {
  const {
    services: {
      chrome: {
        docTitle,
        setBreadcrumbs
      },
      application: {
        navigateToUrl
      },
      serverless
    }
  } = (0, _kibana_react.useKibana)();
  const setTitle = docTitle.change;
  const {
    getAppUrl
  } = (0, _use_navigation.useNavigation)(_common.MANAGEMENT_APP_ID);
  (0, _react.useEffect)(() => {
    const breadcrumbs = [...(!serverless ? [{
      text: _i18n.i18n.translate('xpack.alerting.breadcrumbs.stackManagementLinkText', {
        defaultMessage: 'Stack Management'
      }),
      href: getAppUrl()
    }] : []), ...(topLevelBreadcrumb[pageDeepLink] ? [{
      text: breadcrumbTitle[topLevelBreadcrumb[pageDeepLink]],
      href: getAppUrl({
        deepLinkId: topLevelBreadcrumb[pageDeepLink]
      })
    }] : []), {
      text: breadcrumbTitle[pageDeepLink]
    }];
    if (serverless !== null && serverless !== void 0 && serverless.setBreadcrumbs) {
      serverless.setBreadcrumbs(breadcrumbs);
    } else {
      setBreadcrumbs(addClickHandlers(breadcrumbs, navigateToUrl));
    }
    if (setTitle) {
      setTitle(getTitleFromBreadCrumbs(breadcrumbs));
    }
  }, [pageDeepLink, getAppUrl, navigateToUrl, setBreadcrumbs, setTitle, serverless]);
};
exports.useBreadcrumbs = useBreadcrumbs;