"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RADIUS = exports.EuiSkeletonRectangle = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _global_styling = require("../../global_styling");
var _skeleton_loading = require("./skeleton_loading");
var _skeleton_rectangle = require("./skeleton_rectangle.styles");
var _react2 = require("@emotion/react");
var _excluded = ["isLoading", "borderRadius", "width", "height", "style", "className", "contentAriaLabel", "announceLoadingStatus", "announceLoadedStatus", "ariaLiveProps", "ariaWrapperProps", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var RADIUS = exports.RADIUS = ['s', 'm', 'none'];
var EuiSkeletonRectangle = exports.EuiSkeletonRectangle = function EuiSkeletonRectangle(_ref) {
  var _ref$isLoading = _ref.isLoading,
    isLoading = _ref$isLoading === void 0 ? true : _ref$isLoading,
    _ref$borderRadius = _ref.borderRadius,
    borderRadius = _ref$borderRadius === void 0 ? 's' : _ref$borderRadius,
    _ref$width = _ref.width,
    width = _ref$width === void 0 ? '24px' : _ref$width,
    _ref$height = _ref.height,
    height = _ref$height === void 0 ? '24px' : _ref$height,
    style = _ref.style,
    className = _ref.className,
    contentAriaLabel = _ref.contentAriaLabel,
    announceLoadingStatus = _ref.announceLoadingStatus,
    announceLoadedStatus = _ref.announceLoadedStatus,
    ariaLiveProps = _ref.ariaLiveProps,
    ariaWrapperProps = _ref.ariaWrapperProps,
    children = _ref.children,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = (0, _services.useEuiMemoizedStyles)(_skeleton_rectangle.euiSkeletonRectangleStyles);
  var cssStyles = [styles.euiSkeletonRectangle, styles[borderRadius]];
  return (0, _react2.jsx)(_skeleton_loading.EuiSkeletonLoading, _extends({
    isLoading: isLoading,
    loadingContent: (0, _react2.jsx)("div", _extends({
      className: (0, _classnames.default)('euiSkeletonRectangle', className),
      css: cssStyles,
      style: (0, _global_styling.logicalStyles)(_objectSpread(_objectSpread({}, style), {}, {
        width: width,
        height: height
      }))
    }, rest)),
    loadedContent: children || '',
    contentAriaLabel: contentAriaLabel,
    announceLoadingStatus: announceLoadingStatus,
    announceLoadedStatus: announceLoadedStatus,
    ariaLiveProps: ariaLiveProps
  }, ariaWrapperProps));
};
EuiSkeletonRectangle.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * When true, shows the loading skeleton component.
     * When false, shows any `children` and announces to screen readers that your content has loaded.
     */
  isLoading: _propTypes.default.bool,
  /**
     * Label your loading sections to provide more helpful context to screen readers.
     * For example, pass "API keys" to have screen readers read "Loading API keys" and "Loaded API keys".
     */
  contentAriaLabel: _propTypes.default.string,
  /**
     * Makes a live screen reader announcement when `isLoading` is true
     * @default false
     */
  announceLoadingStatus: _propTypes.default.bool,
  /**
     * Makes a live screen reader announcement when `isLoading` is false
     * @default true
     */
  announceLoadedStatus: _propTypes.default.bool,
  /**
     * Optional props to pass to the `aria-live` region that announces the loading status to screen readers.
     * Accepts any `EuiScreenReaderLive` props.
     */
  ariaLiveProps: _propTypes.default.any,
  /**
     * Optional props to pass to the `aria-busy` wrapper around the skeleton content
     */
  ariaWrapperProps: _propTypes.default.any,
  width: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired]),
  height: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired]),
  borderRadius: _propTypes.default.any
};