"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.computeChartDimensions = computeChartDimensions;
const axes_sizes_1 = require("../axes/axes_sizes");
function computeChartDimensions(parentDimensions, theme, axisTickDimensions, axesStyles, axisSpecs, smSpec, scaleConfigs, settingsSpec) {
    const axesDimensions = (0, axes_sizes_1.getAxesDimensions)(theme, axisTickDimensions, axesStyles, axisSpecs, smSpec, scaleConfigs.x.type, settingsSpec.rotation);
    const chartWidth = parentDimensions.width - axesDimensions.left - axesDimensions.right;
    const chartHeight = parentDimensions.height - axesDimensions.top - axesDimensions.bottom;
    const pad = theme.chartPaddings;
    return {
        leftMargin: axesDimensions.margin.left,
        chartDimensions: {
            top: axesDimensions.top + pad.top,
            left: axesDimensions.left + pad.left,
            width: Math.max(0, chartWidth - pad.left - pad.right),
            height: Math.max(0, chartHeight - pad.top - pad.bottom),
        },
    };
}
//# sourceMappingURL=dimensions.js.map