"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createOnElementClickCaller = createOnElementClickCaller;
const get_heatmap_spec_1 = require("./get_heatmap_spec");
const picked_shapes_1 = require("./picked_shapes");
const __1 = require("../../..");
const create_selector_1 = require("../../../../state/create_selector");
const get_key_pressed_1 = require("../../../../state/selectors/get_key_pressed");
const get_last_click_1 = require("../../../../state/selectors/get_last_click");
const get_settings_spec_1 = require("../../../../state/selectors/get_settings_spec");
const is_clicking_1 = require("../../../../state/utils/is_clicking");
const viewmodel_types_1 = require("../../layout/types/viewmodel_types");
function createOnElementClickCaller() {
    let prevClick = null;
    let selector = null;
    return (state) => {
        if (selector === null && state.chartType === __1.ChartType.Heatmap) {
            selector = (0, create_selector_1.createCustomCachedSelector)([get_heatmap_spec_1.getHeatmapSpecSelector, get_last_click_1.getLastClickSelector, get_settings_spec_1.getSettingsSpecSelector, picked_shapes_1.getPickedShapes, get_key_pressed_1.getKeyPressedSelector], (spec, lastClick, settings, pickedShapes, keyPressed) => {
                if (!spec) {
                    return;
                }
                if (!settings.onElementClick) {
                    return;
                }
                if (!(0, viewmodel_types_1.isPickedCells)(pickedShapes)) {
                    return;
                }
                const nextPickedShapesLength = pickedShapes.length;
                if (nextPickedShapesLength > 0 && (0, is_clicking_1.isClicking)(prevClick, lastClick)) {
                    const elements = pickedShapes.map((value) => [
                        value,
                        {
                            specId: spec.id,
                            key: `spec{${spec.id}}`,
                        },
                    ]);
                    settings.onElementClick(elements, { keyPressed });
                }
                prevClick = lastClick;
            });
        }
        if (selector) {
            selector(state);
        }
    };
}
//# sourceMappingURL=on_element_click_caller.js.map