"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssistantStateAnnotation = void 0;
var _langgraph = require("@langchain/langgraph");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AssistantStateAnnotation = exports.AssistantStateAnnotation = _langgraph.Annotation.Root({
  lastNode: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => 'start'
  }),
  messages: (0, _langgraph.Annotation)({
    reducer: _langgraph.messagesStateReducer,
    default: () => []
  }),
  llmType: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => 'unknown'
  }),
  isStream: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => false
  }),
  isOssModel: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => false
  }),
  connectorId: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  }),
  conversationId: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  }),
  responseLanguage: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => 'English'
  }),
  provider: (0, _langgraph.Annotation)({
    reducer: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  })
});