"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMaxAllowedSampleSize = exports.getAllowedSampleSize = void 0;
var _discoverUtils = require("@kbn/discover-utils");
var _common = require("@kbn/saved-search-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getMaxAllowedSampleSize = uiSettings => {
  return Math.min(uiSettings.get(_discoverUtils.SAMPLE_SIZE_SETTING) || 500, _common.MAX_SAVED_SEARCH_SAMPLE_SIZE);
};
exports.getMaxAllowedSampleSize = getMaxAllowedSampleSize;
const getAllowedSampleSize = (customSampleSize, uiSettings) => {
  if (!customSampleSize || customSampleSize < 0) {
    return uiSettings.get(_discoverUtils.SAMPLE_SIZE_SETTING);
  }
  return Math.max(Math.min(customSampleSize, getMaxAllowedSampleSize(uiSettings)), _common.MIN_SAVED_SEARCH_SAMPLE_SIZE);
};
exports.getAllowedSampleSize = getAllowedSampleSize;