"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QualityIssueFieldInfo = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _fieldTypes = require("@kbn/field-types");
var _constants = require("../../../../common/constants");
var _translations = require("../../../../common/translations");
var _hooks = require("../../../hooks");
var _spark_plot = require("../../common/spark_plot");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QualityIssueFieldInfo = ({
  fieldList,
  children
}) => {
  const {
    fieldFormats,
    isDegradedFieldsLoading
  } = (0, _hooks.useQualityIssues)();
  const dateFormatter = fieldFormats.getDefaultInstance(_fieldTypes.KBN_FIELD_TYPES.DATE, [_fieldTypes.ES_FIELD_TYPES.DATE]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": `datasetQualityDetailsDegradedFieldFlyoutFieldsList-docCount`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, _translations.countColumnName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "datasetQualityDetailsDegradedFieldFlyoutFieldValue-docCount",
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_spark_plot.SparkPlot, {
    series: fieldList === null || fieldList === void 0 ? void 0 : fieldList.timeSeries,
    valueLabel: (0, _eui.formatNumber)(fieldList === null || fieldList === void 0 ? void 0 : fieldList.count, _constants.NUMBER_FORMAT),
    isLoading: isDegradedFieldsLoading
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": `datasetQualityDetailsDegradedFieldFlyoutFieldsList-lastOccurrence`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, _translations.lastOccurrenceColumnName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "datasetQualityDetailsDegradedFieldFlyoutFieldValue-lastOccurrence",
    grow: 2
  }, /*#__PURE__*/_react.default.createElement("span", null, dateFormatter.convert(fieldList === null || fieldList === void 0 ? void 0 : fieldList.lastOccurrence)))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), children);
};
exports.QualityIssueFieldInfo = QualityIssueFieldInfo;