"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManualMitigations = ManualMitigations;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _hooks = require("../../../../../../hooks");
var _component_template_link = require("./component_template_link");
var _pipeline_link = require("./pipeline_link");
var _translations = require("../../../../../../../common/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ManualMitigations() {
  var _integrationDetails$i;
  const {
    integrationDetails,
    loadingState: {
      integrationDetailsLoaded
    }
  } = (0, _hooks.useDatasetQualityDetailsState)();
  const areIntegrationAssetsAvailable = !!(integrationDetails !== null && integrationDetails !== void 0 && (_integrationDetails$i = integrationDetails.integration) !== null && _integrationDetails$i !== void 0 && _integrationDetails$i.areAssetsAvailable);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    isLoading: !integrationDetailsLoaded,
    contentAriaLabel: _translations.otherMitigationsLoadingAriaText,
    width: "100%",
    height: 300,
    borderRadius: "none",
    "data-test-subj": "datasetQualityDetailsFlyoutManualMitigationsLoading",
    className: "datasetQualityDetailsFlyoutManualMitigationsLoading"
  }, /*#__PURE__*/_react.default.createElement(_component_template_link.CreateEditComponentTemplateLink, {
    areIntegrationAssetsAvailable: areIntegrationAssetsAvailable
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_pipeline_link.CreateEditPipelineLink, {
    areIntegrationAssetsAvailable: areIntegrationAssetsAvailable
  }));
}