"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.debounceByKey = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Uses a debouncer collector behind a debouncing factory to work on a set of functions
 *
 * @template F - function type
 * @param {F} fn - function to debounce
 * @param {number} waitInMs
 * @returns {(key: string) => Function}
 */
const debounceByKey = (fn, waitInMs) => {
  const debouncerCollector = {};
  return key => {
    if (!debouncerCollector[key]) {
      debouncerCollector[key] = (0, _lodash.debounce)(fn, waitInMs, {
        leading: true
      });
    }
    return debouncerCollector[key];
  };
};
exports.debounceByKey = debounceByKey;