"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDashboardPanelPlacementSetting = exports.getRegistryItem = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const registry = new Map();
const registerDashboardPanelPlacementSetting = (embeddableType, getPanelPlacementSettings) => {
  if (registry.has(embeddableType)) {
    throw new Error(_i18n.i18n.translate('dashboard.panelPlacement.panelPlacementSettingsExistsError', {
      defaultMessage: 'Panel placement settings for embeddable type {panelType} already exists',
      values: {
        panelType: embeddableType
      }
    }));
  }
  registry.set(embeddableType, getPanelPlacementSettings);
};

/**
 * Use getPanelPlacementSetting to access registry
 */
exports.registerDashboardPanelPlacementSetting = registerDashboardPanelPlacementSetting;
const getRegistryItem = embeddableType => {
  return registry.get(embeddableType);
};
exports.getRegistryItem = getRegistryItem;