"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createUsageTracker = void 0;
var _analytics = require("@kbn/analytics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const APP_TRACKER_NAME = 'console';
const createUsageTracker = usageCollection => {
  const track = (type, name) => usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.reportUiCounter(APP_TRACKER_NAME, type, name);
  return {
    count: eventName => {
      track(_analytics.METRIC_TYPE.COUNT, eventName);
    },
    load: eventName => {
      track(_analytics.METRIC_TYPE.LOADED, eventName);
    }
  };
};
exports.createUsageTracker = createUsageTracker;