"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimestampTableCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Offset top-aligned tooltips so that cell actions are visible
const datagridToolTipOffset = (0, _react2.css)`
  &[data-position='top'] {
    margin-block-start: -8px;
  }
`;
const TimestampTableCell = ({
  timestamp
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "bottom",
  css: datagridToolTipOffset,
  content: (0, _moment.default)(timestamp).format(_cloudSecurityPostureCommon.CSP_MOMENT_FORMAT)
}, /*#__PURE__*/_react.default.createElement("span", {
  tabIndex: 0
}, (0, _moment.default)(timestamp).fromNow()));
exports.TimestampTableCell = TimestampTableCell;