"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseOnboardingSolution = parseOnboardingSolution;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Cloud does not type the value of the "use case" that is set during onboarding for a deployment. Any string can
 * be passed. This function maps the known values to the Kibana values.
 *
 * @param value The solution value set by Cloud.
 * @returns The default solution value for onboarding that matches Kibana naming.
 */
function parseOnboardingSolution(value) {
  var _solutions$find;
  if (!value) return;
  const solutions = [{
    cloudValue: 'search',
    kibanaValue: 'es'
  }, {
    cloudValue: 'elasticsearch',
    kibanaValue: 'es'
  }, {
    cloudValue: 'observability',
    kibanaValue: 'oblt'
  }, {
    cloudValue: 'security',
    kibanaValue: 'security'
  }];
  return (_solutions$find = solutions.find(({
    cloudValue
  }) => value.toLowerCase() === cloudValue)) === null || _solutions$find === void 0 ? void 0 : _solutions$find.kibanaValue;
}