"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetActionLicense = void 0;
var _reactQuery = require("@tanstack/react-query");
var _kibana = require("../common/lib/kibana");
var _api = require("./api");
var i18n = _interopRequireWildcard(require("./translations"));
var _domain = require("../../common/types/domain");
var _constants = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MINIMUM_LICENSE_REQUIRED_CONNECTOR = _domain.ConnectorTypes.jira;
const useGetActionLicense = () => {
  const toasts = (0, _kibana.useToasts)();
  return (0, _reactQuery.useQuery)(_constants.casesQueriesKeys.license(), async ({
    signal
  }) => {
    var _response$find;
    const response = await (0, _api.getActionLicense)(signal);
    return (_response$find = response.find(l => l.id === MINIMUM_LICENSE_REQUIRED_CONNECTOR)) !== null && _response$find !== void 0 ? _response$find : null;
  }, {
    onError: error => {
      if (error.name !== 'AbortError') {
        toasts.addError(error.body && error.body.message ? new Error(error.body.message) : error, {
          title: i18n.ERROR_TITLE
        });
      }
    }
  });
};
exports.useGetActionLicense = useGetActionLicense;