"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteVar = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getCancelButtonLabel: () => _i18n.i18n.translate('xpack.canvas.varConfigDeleteVar.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  }),
  getDeleteButtonLabel: () => _i18n.i18n.translate('xpack.canvas.varConfigDeleteVar.deleteButtonLabel', {
    defaultMessage: 'Delete variable'
  }),
  getTitle: () => _i18n.i18n.translate('xpack.canvas.varConfigDeleteVar.titleLabel', {
    defaultMessage: 'Delete variable?'
  }),
  getWarningDescription: () => _i18n.i18n.translate('xpack.canvas.varConfigDeleteVar.warningDescription', {
    defaultMessage: 'Deleting this variable may adversely affect the workpad. Are you sure you wish to continue?'
  })
};
const DeleteVar = ({
  selectedVar,
  onCancel,
  onDelete
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasVarHeader__triggerWrapper"
  }, /*#__PURE__*/_react.default.createElement("button", {
    className: "canvasVarHeader__button",
    type: "button",
    onClick: () => onCancel()
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "canvasVarHeader__iconWrapper"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sortLeft",
    style: {
      verticalAlign: 'top'
    }
  })), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement("span", {
    className: "canvasVarHeader__anchor"
  }, strings.getTitle())))), /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasSidebar__accordionContent"
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, strings.getWarningDescription()))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    size: "s",
    fill: true,
    onClick: () => onDelete(selectedVar),
    iconType: "trash"
  }, strings.getDeleteButtonLabel())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    onClick: () => onCancel()
  }, strings.getCancelButtonLabel()))))));
};
exports.DeleteVar = DeleteVar;